/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.http.rest;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMaps;
import com.jn.langx.util.net.http.HttpMethod;
import com.jn.langx.util.net.http.HttpStatus;
import java.util.List;
import java.util.Map;

public class RestRespBody<T> {
    private boolean success;
    @Nullable
    private T data;
    private int statusCode;
    private long timestamp;
    private String errorCode;
    private String errorMessage;
    @Nullable
    private String url;
    private HttpMethod method;
    @Nullable
    private Map<String, List<String>> responseHeaders;
    @Nullable
    private Map<String, List<String>> requestHeaders;

    public RestRespBody() {
    }

    public RestRespBody(boolean success, int statusCode, T data, String errorCode, String errorMessage) {
        this.success = success;
        this.statusCode = statusCode;
        this.data = data;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.timestamp = System.currentTimeMillis();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, List<String>> responseHeaders) {
        if (responseHeaders instanceof MultiValueMap) {
            MultiValueMap map = (MultiValueMap)responseHeaders;
            this.setResponseHeaders(map.toMap());
        } else {
            this.responseHeaders = responseHeaders;
        }
    }

    public void withResponseHeaders(MultiValueMap<String, String> responseHeaders) {
        if (responseHeaders != null) {
            this.setRequestHeaders(responseHeaders.toMap());
        }
    }

    public void withResponseHeaders(Map<String, String> responseHeaders) {
        this.withResponseHeaders(MultiValueMaps.toMultiValueMap(responseHeaders));
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void withRequestHeaders(MultiValueMap<String, String> requestHeaders) {
        if (requestHeaders != null) {
            this.setRequestHeaders(requestHeaders.toMap());
        }
    }

    public void withRequestHeaders(Map<String, String> requestHeaders) {
        this.withRequestHeaders(MultiValueMaps.toMultiValueMap(requestHeaders));
    }

    public void setRequestHeaders(Map<String, List<String>> requestHeaders) {
        if (requestHeaders instanceof MultiValueMap) {
            MultiValueMap map = (MultiValueMap)requestHeaders;
            this.setRequestHeaders(map.toMap());
        } else {
            this.requestHeaders = requestHeaders;
        }
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public static <T> RestRespBody<T> ok() {
        return RestRespBody.success(HttpStatus.OK.value(), null);
    }

    public static <T> RestRespBody<T> ok(T data) {
        return RestRespBody.success(data);
    }

    public static <T> RestRespBody<T> success(T data) {
        return RestRespBody.success(HttpStatus.OK.value(), data);
    }

    public static <T> RestRespBody<T> success(int statusCode, T data) {
        return RestRespBody.success(statusCode, data, "", "");
    }

    public static <T> RestRespBody<T> success(int statusCode, T data, String errorCode, String errorMessage) {
        return new RestRespBody<T>(true, statusCode, data, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error400(String errorCode, String errorMessage) {
        return RestRespBody.badRequest(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> badRequest(String errorCode, String errorMessage) {
        return new RestRespBody<Object>(false, 400, null, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error401(String errorCode, String errorMessage) {
        return RestRespBody.unauthorized(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> unauthorized(String errorCode, String errorMessage) {
        return new RestRespBody<Object>(false, HttpStatus.UNAUTHORIZED.value(), null, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error403(String errorCode, String errorMessage) {
        return RestRespBody.forbidden(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> forbidden(String errorCode, String errorMessage) {
        return new RestRespBody<Object>(false, 403, null, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error404(String errorCode, String errorMessage) {
        return RestRespBody.notFound(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> notFound(String errorCode, String errorMessage) {
        return new RestRespBody<Object>(false, 404, null, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error500(String errorCode, String errorMessage) {
        return RestRespBody.serverInternalError(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> serverInternalError(String errorCode, String errorMessage) {
        return RestRespBody.error(500, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error502(String errorCode, String errorMessage) {
        return RestRespBody.badGateway(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> badGateway(String errorCode, String errorMessage) {
        return RestRespBody.error(502, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error503(String errorCode, String errorMessage) {
        return RestRespBody.serviceUnavailable(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> serviceUnavailable(String errorCode, String errorMessage) {
        return RestRespBody.error(503, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error504(String errorCode, String errorMessage) {
        return RestRespBody.gatewayTimeout(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> gatewayTimeout(String errorCode, String errorMessage) {
        return RestRespBody.error(504, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error505(int statusCode, String errorCode, String errorMessage) {
        return RestRespBody.httpVersionNotSupported(errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> httpVersionNotSupported(String errorCode, String errorMessage) {
        return RestRespBody.error(505, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error511(int statusCode, String errorCode, String errorMessage) {
        return new RestRespBody<Object>(false, statusCode, null, errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> unAuthentication(String errorCode, String errorMessage) {
        return RestRespBody.error(HttpStatus.NETWORK_AUTHENTICATION_REQUIRED.value(), errorCode, errorMessage);
    }

    public static <T> RestRespBody<T> error(int statusCode, String errorCode, String errorMessage) {
        return new RestRespBody<Object>(false, statusCode, null, errorCode, errorMessage);
    }
}

