/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.distributed.session.impl;

import com.jn.langx.distributed.session.Session;
import com.jn.langx.distributed.session.SessionManager;
import com.jn.langx.distributed.session.SessionManagerAware;
import com.jn.langx.util.collection.AbstractAttributable;
import java.util.Date;

public class SimpleSession
extends AbstractAttributable
implements Session,
SessionManagerAware {
    private String id;
    private Date startTime;
    private Date lastAccessTime;
    private long maxInactiveInterval;
    private boolean invalid = false;
    private transient SessionManager sessionManager;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (this.startTime == null) {
            this.startTime = startTime;
        }
    }

    @Override
    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public long getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(long maxIdleTimeInMillis) {
        this.maxInactiveInterval = maxIdleTimeInMillis;
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public boolean isExpired() {
        if (!this.invalid) {
            return this.getExpireTime().getTime() <= System.currentTimeMillis();
        }
        return this.invalid;
    }

    @Override
    public Date getExpireTime() {
        return new Date(this.lastAccessTime.getTime() + this.maxInactiveInterval);
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
        if (this.sessionManager != null) {
            this.sessionManager.invalidate(this);
        }
    }
}

