/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.distributed.cluster.loadbalance;

import com.jn.langx.distributed.cluster.loadbalance.AbstractLoadBalanceStrategy;
import com.jn.langx.distributed.cluster.loadbalance.InvocationKeyGetter;
import com.jn.langx.distributed.cluster.loadbalance.Node;
import com.jn.langx.distributed.cluster.loadbalance.UndefinedInvocationKeyGetter;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Maps;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.function.Supplier;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class RoundRobinLoadBalanceStrategy<NODE extends Node, INVOCATION>
extends AbstractLoadBalanceStrategy<NODE, INVOCATION> {
    private static final int RECYCLE_PERIOD = 60000;
    private InvocationKeyGetter<NODE, INVOCATION> invocationKeyGetter = new UndefinedInvocationKeyGetter();
    private ConcurrentMap<String, ConcurrentMap<String, WeightedRoundRobin>> invocationWeightMap = new ConcurrentHashMap<String, ConcurrentMap<String, WeightedRoundRobin>>();

    public RoundRobinLoadBalanceStrategy() {
        this.setName("RoundRobin");
    }

    public void setInvocationKeyGetter(InvocationKeyGetter invocationKeyGetter) {
        if (invocationKeyGetter != null) {
            this.invocationKeyGetter = invocationKeyGetter;
        }
    }

    @Override
    protected NODE doSelect(List<NODE> reachableNodes, INVOCATION invocation) {
        String key = this.invocationKeyGetter.get((Node)reachableNodes.get(0), invocation);
        ConcurrentMap<String, WeightedRoundRobin> map = Maps.putIfAbsent(this.invocationWeightMap, key, new Supplier<String, ConcurrentMap<String, WeightedRoundRobin>>(){

            @Override
            public ConcurrentMap<String, WeightedRoundRobin> get(String k) {
                return new ConcurrentHashMap<String, WeightedRoundRobin>();
            }
        });
        int totalWeight = 0;
        long maxCurrent = Long.MIN_VALUE;
        final long now = System.currentTimeMillis();
        Node selectedNode = null;
        WeightedRoundRobin selectedWRR = null;
        for (Node reachableNode : reachableNodes) {
            WeightedRoundRobin weightedRoundRobin;
            String identifyString = reachableNode.getId();
            final int weight = this.getWeight(reachableNode, invocation);
            if (weight != (weightedRoundRobin = Maps.putIfAbsent(map, identifyString, new Supplier<String, WeightedRoundRobin>(){

                @Override
                public WeightedRoundRobin get(String k) {
                    WeightedRoundRobin wrr = new WeightedRoundRobin();
                    wrr.setWeight(weight);
                    return wrr;
                }
            })).getWeight()) {
                weightedRoundRobin.setWeight(weight);
            }
            long cur = weightedRoundRobin.increaseCurrent();
            weightedRoundRobin.setLastUpdate(now);
            if (cur > maxCurrent) {
                maxCurrent = cur;
                selectedNode = reachableNode;
                selectedWRR = weightedRoundRobin;
            }
            totalWeight += weight;
        }
        if (reachableNodes.size() != map.size()) {
            Collects.removeIf(map, new Predicate2<String, WeightedRoundRobin>(){

                @Override
                public boolean test(String key, WeightedRoundRobin wrr) {
                    return now - wrr.getLastUpdate() > 60000L;
                }
            });
        }
        if (selectedNode != null) {
            selectedWRR.sel(totalWeight);
            return (NODE)selectedNode;
        }
        return (NODE)((Node)reachableNodes.get(0));
    }

    protected static class WeightedRoundRobin {
        private int weight;
        private final AtomicLong current = new AtomicLong(0L);
        private long lastUpdate;

        protected WeightedRoundRobin() {
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
            this.current.set(0L);
        }

        public long increaseCurrent() {
            return this.current.addAndGet(this.weight);
        }

        public void sel(int total) {
            this.current.addAndGet(-1L * (long)total);
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }
}

