/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.distributed.cluster.loadbalance;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.distributed.cluster.loadbalance.LoadBalanceStrategy;
import com.jn.langx.distributed.cluster.loadbalance.LoadBalancer;
import com.jn.langx.distributed.cluster.loadbalance.Node;
import com.jn.langx.distributed.cluster.loadbalance.Weighter;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Predicate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoadBalanceStrategy<NODE extends Node, INVOCATION>
implements LoadBalanceStrategy<NODE, INVOCATION> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    @Nullable
    private Weighter weighter;
    private LoadBalancer<NODE, INVOCATION> loadBalancer;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setWeighter(Weighter weighter) {
        this.weighter = weighter;
    }

    @Override
    public LoadBalancer<NODE, INVOCATION> getLoadBalancer() {
        return this.loadBalancer;
    }

    @Override
    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public int getWeight(NODE node, INVOCATION invocation) {
        if (this.weighter != null) {
            return this.weighter.getWeight(node, invocation);
        }
        return 0;
    }

    protected abstract NODE doSelect(List<NODE> var1, INVOCATION var2);

    @Override
    public NODE select(List<NODE> reachableNodes, INVOCATION invocation) {
        if (Emptys.isEmpty(reachableNodes = Pipeline.of(reachableNodes).filter(new Predicate<NODE>(){

            @Override
            public boolean test(NODE node) {
                return AbstractLoadBalanceStrategy.this.getLoadBalancer().hasNode(node);
            }
        }).asList()) || this.getLoadBalancer().isEmpty()) {
            this.logger.warn("Can't find any reachable nodes");
            return null;
        }
        if (reachableNodes.size() == 1) {
            return (NODE)((Node)reachableNodes.get(0));
        }
        return this.doSelect(reachableNodes, invocation);
    }
}

