/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration.file.directoryfile;

import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.ConfigurationLoader;
import com.jn.langx.configuration.InputStreamConfigurationParser;
import com.jn.langx.io.resource.DirectoryBasedFileResourceLoader;
import com.jn.langx.io.resource.FileResource;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.FileFilter;
import com.jn.langx.util.io.file.Filenames;
import com.jn.langx.util.io.file.filter.AllFileFilter;
import com.jn.langx.util.io.file.filter.IsFileFilter;
import com.jn.langx.util.io.file.filter.ReadableFileFilter;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBasedFileConfigurationLoader<T extends Configuration>
implements ConfigurationLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryBasedFileConfigurationLoader.class);
    private DirectoryBasedFileResourceLoader resourceLoader;
    private InputStreamConfigurationParser<T> configurationParser;
    private final List<FileFilter> filters = new ArrayList<FileFilter>();
    private Supplier<String, String> configurationIdSupplier;
    private Supplier<String, String> filenameSupplier;

    public DirectoryBasedFileConfigurationLoader() {
        this.filters.add(new ReadableFileFilter());
        this.filters.add(new IsFileFilter());
    }

    public void setDirectory(String directory) {
        this.resourceLoader = new DirectoryBasedFileResourceLoader(directory);
    }

    public void setConfigurationIdSupplier(Supplier<String, String> configurationIdSupplier) {
        this.configurationIdSupplier = configurationIdSupplier;
    }

    public void setFilenameSupplier(Supplier<String, String> filenameSupplier) {
        this.filenameSupplier = filenameSupplier;
    }

    public void setConfigurationParser(InputStreamConfigurationParser<T> configurationParser) {
        this.configurationParser = configurationParser;
    }

    public void addFilters(FileFilter ... f) {
        Collects.addAll(this.filters, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T load(String id) {
        FileResource fileResource = this.resourceLoader.loadResource(this.filenameSupplier.get(id));
        InputStream inputStream = null;
        Configuration configuration = null;
        try {
            inputStream = fileResource.getInputStream();
            configuration = (Configuration)this.configurationParser.parse(inputStream);
            configuration.setId(id);
        }
        catch (Throwable ex) {
            logger.info("Error occur when load configuration: {}", (Object)id);
        }
        finally {
            IOs.close(inputStream);
        }
        return (T)configuration;
    }

    public Map<String, Long> scanConfigurationFileModifiedTimes() {
        return Pipeline.of(this.resourceLoader.listFiles()).filter(new AllFileFilter(this.filters)).collect(Collects.toHashMap(new Function<File, String>(){

            @Override
            public String apply(File file) {
                return (String)DirectoryBasedFileConfigurationLoader.this.configurationIdSupplier.get(Filenames.extractFilename(file.getAbsolutePath(), false));
            }
        }, new Function<File, Long>(){

            @Override
            public Long apply(File file) {
                return file.lastModified();
            }
        }, false));
    }
}

