/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration.database;

import com.jn.langx.configuration.AbstractConfigurationRepository;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.database.DatabaseBasedConfigurationLoader;
import com.jn.langx.configuration.database.DatabaseBasedConfigurationWriter;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.diff.CollectionDiffResult;
import com.jn.langx.util.collection.diff.KeyBuilder;
import com.jn.langx.util.function.Consumer;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseBasedConfigurationRepository<T extends Configuration>
extends AbstractConfigurationRepository<T, DatabaseBasedConfigurationLoader<T>, DatabaseBasedConfigurationWriter<T>> {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseBasedConfigurationRepository.class);

    @Override
    public void init() throws InitializationException {
        if (!this.inited) {
            super.init();
            Preconditions.checkNotNull(this.loader, "the configuration load is null");
            if (this.writer == null) {
                logger.warn("The writer is not specified for the repository ({}), will disable write configuration to storage", (Object)this.name);
            }
            if (this.reloadIntervalInSeconds > 1) {
                logger.info("The configuration refresh task is disabled for repository: {}", (Object)this.name);
            }
            this.inited = true;
        }
    }

    @Override
    public void reload() {
        List newConfigs = Collects.asList(((DatabaseBasedConfigurationLoader)this.loader).loadAll());
        Collection oldConfigs = this.getAll().values();
        CollectionDiffResult differResult = Collects.diff(oldConfigs, newConfigs, this.getComparator(), new KeyBuilder<String, T>(){

            @Override
            public String getKey(T configuration) {
                return configuration.getId();
            }
        });
        if (differResult.hasDifference()) {
            Collects.forEach(differResult.getAdds(), new Consumer<T>(){

                @Override
                public void accept(T newConfig) {
                    DatabaseBasedConfigurationRepository.this.add(newConfig, false);
                }
            });
            Collects.forEach(differResult.getUpdates(), new Consumer<T>(){

                @Override
                public void accept(T t) {
                    DatabaseBasedConfigurationRepository.this.update(t, false);
                }
            });
            Collects.forEach(differResult.getRemoves(), new Consumer<T>(){

                @Override
                public void accept(T t) {
                    DatabaseBasedConfigurationRepository.this.removeById(t.getId());
                }
            });
        }
    }
}

