/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration;

import com.jn.langx.configuration.AbstractConfigurationRepository;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.ConfigurationLoader;
import com.jn.langx.configuration.ConfigurationRepository;
import com.jn.langx.configuration.ConfigurationWriter;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.NonAbsentHashMap;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.struct.Holder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MultipleLevelConfigurationRepository<T extends Configuration, Loader extends ConfigurationLoader<T>, Writer extends ConfigurationWriter<T>>
extends AbstractConfigurationRepository<T, Loader, Writer> {
    private Map<String, Integer> delegateOrderMap = new NonAbsentHashMap<String, Integer>(new Supplier<String, Integer>(){

        @Override
        public Integer get(String input) {
            return Integer.MAX_VALUE;
        }
    });
    private Map<String, ConfigurationRepository> delegates = new TreeMap<String, ConfigurationRepository>(new Comparator<String>(){

        @Override
        public int compare(String repositoryName1, String repositoryName2) {
            return (Integer)MultipleLevelConfigurationRepository.this.delegateOrderMap.get(repositoryName1) - (Integer)MultipleLevelConfigurationRepository.this.delegateOrderMap.get(repositoryName2);
        }
    });

    public void addRepository(ConfigurationRepository repository) {
        this.addRepository(repository, Integer.MAX_VALUE);
    }

    public void addRepository(ConfigurationRepository repository, int order) {
        this.delegateOrderMap.put(repository.getName(), order);
        this.delegates.put(repository.getName(), repository);
    }

    public void removeRepository(String repositoryName) {
        this.delegateOrderMap.remove(repositoryName);
        this.delegates.remove(repositoryName);
    }

    @Override
    public void startup() {
        Pipeline.of(this.delegates.values()).reverse(true).forEach(new Consumer2<Integer, ConfigurationRepository>(){

            @Override
            public void accept(Integer index, ConfigurationRepository repository) {
                repository.startup();
            }
        });
        super.startup();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        Pipeline.of(this.delegates.values()).forEach(new Consumer<ConfigurationRepository>(){

            @Override
            public void accept(ConfigurationRepository configurationRepository) {
                configurationRepository.shutdown();
            }
        });
    }

    @Override
    public T getById(final String id) {
        Object t = super.getById(id);
        if (t == null) {
            final Holder holder = new Holder();
            Collects.forEach(this.delegates.values(), new Consumer<ConfigurationRepository>(){

                @Override
                public void accept(ConfigurationRepository configurationRepository) {
                    holder.set(configurationRepository.getById(id));
                }
            }, new Predicate<ConfigurationRepository>(){

                @Override
                public boolean test(ConfigurationRepository configurationRepository) {
                    return !holder.isNull();
                }
            });
            t = (Configuration)holder.get();
        }
        return t;
    }

    public T getById(String repositoryName, String id) {
        ConfigurationRepository repository = this.delegates.get(repositoryName);
        if (repository != null) {
            return repository.getById(id);
        }
        return null;
    }

    public T getById(final String id, Function<List<T>, T> mapper) {
        return (T)((Configuration)mapper.apply(Pipeline.of(this.delegates.keySet()).map(new Function<String, T>(){

            @Override
            public T apply(String repositoryName) {
                return MultipleLevelConfigurationRepository.this.getById(repositoryName, id);
            }
        }).asList()));
    }

    @Override
    public void removeById(final String id, final boolean sync) {
        super.removeById(id, sync);
        Collects.forEach(this.delegates.values(), new Consumer<ConfigurationRepository>(){

            @Override
            public void accept(ConfigurationRepository configurationRepository) {
                configurationRepository.removeById(id, sync);
            }
        });
    }

    private ConfigurationRepository findFirstRepository(final String id) {
        if (super.getById(id) != null) {
            return this;
        }
        return Collects.findFirst(this.delegates.values(), new Predicate<ConfigurationRepository>(){

            @Override
            public boolean test(ConfigurationRepository value) {
                return value.getById(id) != null;
            }
        });
    }

    @Override
    public T add(T configuration, boolean sync) {
        return super.add(configuration, sync);
    }

    @Override
    public void update(T configuration, boolean sync) {
        ConfigurationRepository old = this.findFirstRepository(configuration.getId());
        if (old != null) {
            old.update(configuration, sync);
        } else {
            super.update(configuration, sync);
        }
    }

    @Override
    public Map<String, T> getAll() {
        final HashMap map = Collects.emptyHashMap(true);
        Pipeline.of(this.delegates.values()).reverse(true).forEach(new Consumer<ConfigurationRepository>(){

            @Override
            public void accept(ConfigurationRepository configurationRepository) {
                map.putAll(configurationRepository.getAll());
            }
        });
        return map;
    }
}

