/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration;

import com.jn.langx.Reloadable;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.cache.Cache;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.ConfigurationEventFactory;
import com.jn.langx.configuration.ConfigurationEventType;
import com.jn.langx.configuration.ConfigurationLoader;
import com.jn.langx.configuration.ConfigurationRepository;
import com.jn.langx.configuration.ConfigurationWriter;
import com.jn.langx.event.EventPublisher;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.concurrent.CommonThreadFactory;
import com.jn.langx.util.timing.timer.HashedWheelTimer;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationRepository<T extends Configuration, Loader extends ConfigurationLoader<T>, Writer extends ConfigurationWriter<T>>
implements ConfigurationRepository<T, Loader, Writer>,
Reloadable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigurationRepository.class);
    @NonNull
    protected String name;
    @NonNull
    protected Loader loader;
    @Nullable
    protected Writer writer;
    protected volatile boolean inited = false;
    protected volatile boolean running = false;
    @Nullable
    private EventPublisher eventPublisher;
    @Nullable
    private ConfigurationEventFactory<T> eventFactory;
    @NonNull
    private Cache<String, T> cache;
    private Comparator<T> comparator;
    protected int reloadIntervalInSeconds = -1;
    private Timer timer;

    public void setReloadIntervalInSeconds(int reloadIntervalInSeconds) {
        this.reloadIntervalInSeconds = reloadIntervalInSeconds;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setCache(Cache<String, T> cache) {
        this.cache = cache;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setEventFactory(ConfigurationEventFactory<T> eventFactory) {
        this.eventFactory = eventFactory;
    }

    @Override
    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        this.eventPublisher = publisher;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    @Override
    public void startup() {
        if (!this.inited) {
            this.init();
        }
        Preconditions.checkNotNull(this.cache);
        this.running = true;
        logger.info("Startup configuration repository: {}", (Object)this.name);
        if (this.reloadIntervalInSeconds > 0) {
            try {
                this.reload();
            }
            catch (Throwable ex) {
                logger.warn(ex.getMessage(), ex);
            }
            if (this.timer == null) {
                logger.warn("The timer is not specified for the repository ({}) , will use a simple timer", (Object)this.name);
                this.timer = new HashedWheelTimer(new CommonThreadFactory("Configuration", true), 50L, TimeUnit.MILLISECONDS);
            }
            this.timer.newTimeout(new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    try {
                        AbstractConfigurationRepository.this.reload();
                    }
                    catch (Throwable ex) {
                        logger.error(ex.getMessage(), ex);
                    }
                    finally {
                        if (AbstractConfigurationRepository.this.running) {
                            AbstractConfigurationRepository.this.timer.newTimeout(this, AbstractConfigurationRepository.this.reloadIntervalInSeconds, TimeUnit.SECONDS);
                        }
                    }
                }
            }, this.reloadIntervalInSeconds, TimeUnit.SECONDS);
        } else {
            this.reload();
        }
    }

    @Override
    public void shutdown() {
        this.running = false;
        logger.info("Shutdown configuration repository: {}", (Object)this.name);
        this.cache.clean();
    }

    @Override
    public void setConfigurationLoader(Loader loader) {
        this.loader = loader;
    }

    @Override
    public Loader getConfigurationLoader() {
        return this.loader;
    }

    @Override
    public Writer getConfigurationWriter() {
        return this.writer;
    }

    @Override
    public void setConfigurationWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public T getById(String id) {
        return (T)((Configuration)this.cache.get(id));
    }

    @Override
    public void removeById(String id) {
        this.removeById(id, true);
    }

    @Override
    public void removeById(String id, boolean sync) {
        Configuration configuration = (Configuration)this.cache.getIfPresent(id);
        if (configuration != null) {
            this.logMutation(ConfigurationEventType.REMOVE, configuration);
            if (sync && this.writer != null && this.writer.isSupportsRemove()) {
                this.writer.remove(id);
            }
            this.cache.remove(id);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.ADD, configuration));
            }
        }
    }

    @Override
    public void add(T configuration) {
        this.add(configuration, true);
    }

    @Override
    public T add(T configuration, boolean sync) {
        if (this.running) {
            this.logMutation(ConfigurationEventType.ADD, configuration);
            if (sync && this.writer != null && this.writer.isSupportsWrite()) {
                this.writer.write(configuration);
            }
            this.cache.set(configuration.getId(), configuration);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.ADD, configuration));
            }
        }
        return configuration;
    }

    @Override
    public void update(T configuration) {
        this.update(configuration, true);
    }

    @Override
    public void update(T configuration, boolean sync) {
        if (this.running) {
            this.logMutation(ConfigurationEventType.UPDATE, configuration);
            if (sync && this.writer != null && this.writer.isSupportsRewrite()) {
                this.writer.rewrite(configuration);
            }
            this.cache.set(configuration.getId(), configuration);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.UPDATE, configuration));
            }
        }
    }

    private void logMutation(ConfigurationEventType eventType, T configuration) {
        if (logger.isInfoEnabled()) {
            String template = this.eventFactory == null ? " a configuration: {}" : (Strings.startsWithVowelLetter(this.eventFactory.getDomain()) ? " an {} configuration: {}" : " a {} configuration: {}");
            template = Strings.upperCase(eventType.name().toLowerCase(), 0, 1) + template;
            if (this.eventFactory != null) {
                logger.info(template, (Object)this.eventFactory.getDomain(), configuration);
            } else {
                logger.info(template, configuration);
            }
        }
    }

    @Override
    public void init() throws InitializationException {
        Preconditions.checkNotNull(this.name, "Repository has no named");
        logger.info("Initial configuration repository: {}", (Object)this.name);
    }

    @Override
    public Map<String, T> getAll() {
        return Collections.unmodifiableMap(this.cache.toMap());
    }

    @Override
    public void reload() {
        logger.info("Reload repository {}", (Object)this.name);
    }
}

