/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.commandline.util;

public class CommandLineDebugUtils {
    public static final String COMMONS_EXEC_LENIENT = "com.jn.langx.commandline.lenient";
    public static final String COMMONS_EXEC_DEBUG = "com.jn.langx.commandline.debug";

    public static void handleException(String msg, Exception e) {
        if (CommandLineDebugUtils.isDebugEnabled()) {
            System.err.println(msg);
            e.printStackTrace();
        }
        if (!CommandLineDebugUtils.isLenientEnabled()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isDebugEnabled() {
        String debug = System.getProperty(COMMONS_EXEC_DEBUG, Boolean.FALSE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(debug);
    }

    public static boolean isLenientEnabled() {
        String lenient = System.getProperty(COMMONS_EXEC_LENIENT, Boolean.TRUE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(lenient);
    }
}

