/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.commandline;

import com.jn.langx.commandline.CommandLine;
import com.jn.langx.commandline.CommandLineExecutor;
import com.jn.langx.commandline.DefaultExecuteResultHandler;
import com.jn.langx.commandline.ExecuteException;
import com.jn.langx.commandline.ExecuteResultHandler;
import com.jn.langx.commandline.ExecuteStreamHandler;
import com.jn.langx.commandline.ExecuteWatchdog;
import com.jn.langx.commandline.InstructionSequence;
import com.jn.langx.commandline.InstructionSequenceDestroyer;
import com.jn.langx.commandline.ProcessAdapter;
import com.jn.langx.commandline.PumpStreamHandler;
import com.jn.langx.commandline.launcher.CommandLauncher;
import com.jn.langx.commandline.launcher.CommandLauncherFactory;
import com.jn.langx.commandline.launcher.LocalCommandLauncher;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.concurrent.completion.CompletableFuture;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Supplier0;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandLineExecutor
implements CommandLineExecutor {
    private Logger logger = LoggerFactory.getLogger(DefaultCommandLineExecutor.class);
    private ExecutorService executorService;
    private ExecuteStreamHandler streamHandler = new PumpStreamHandler();
    private ExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
    private File workingDirectory;
    private ExecuteWatchdog watchdog;
    private int[] exitValues;
    private CommandLauncher launcher = CommandLauncherFactory.createVMLauncher();
    private InstructionSequenceDestroyer processDestroyer;
    private Throwable exceptionCaught = null;

    @Override
    public ExecuteStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    @Override
    public void setStreamHandler(ExecuteStreamHandler streamHandler) {
        if (streamHandler != null) {
            this.streamHandler = streamHandler;
        }
    }

    @Override
    public ExecuteResultHandler getResultHandler() {
        return this.resultHandler;
    }

    @Override
    public void setResultHandler(ExecuteResultHandler resultHandler) {
        if (resultHandler != null) {
            this.resultHandler = resultHandler;
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public DefaultCommandLineExecutor() {
        this.exitValues = new int[0];
        this.workingDirectory = new File(".");
    }

    public void setLauncher(CommandLauncher launcher) {
        if (launcher != null) {
            this.launcher = launcher;
        }
    }

    @Override
    public ExecuteWatchdog getWatchdog() {
        return this.watchdog;
    }

    @Override
    public void setWatchdog(ExecuteWatchdog watchDog) {
        this.watchdog = watchDog;
    }

    @Override
    public InstructionSequenceDestroyer getProcessDestroyer() {
        return this.processDestroyer;
    }

    @Override
    public void setProcessDestroyer(InstructionSequenceDestroyer processDestroyer) {
        this.processDestroyer = processDestroyer;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(File dir) {
        this.workingDirectory = dir;
    }

    @Override
    public int execute(CommandLine command) throws ExecuteException, IOException {
        return this.execute(false, command);
    }

    @Override
    public int execute(boolean async, CommandLine command) throws IOException {
        return this.execute(async, command, (Map<String, String>)null);
    }

    @Override
    public int execute(CommandLine command, Map<String, String> environment) throws ExecuteException, IOException {
        return this.execute(false, command, environment);
    }

    @Override
    public int execute(boolean async, CommandLine command, Map<String, String> environment) throws IOException {
        return this.execute(async, command, environment, null, null, null);
    }

    @Override
    public int execute(CommandLine command, ExecuteResultHandler handler) throws ExecuteException, IOException {
        return this.execute(false, command, handler);
    }

    @Override
    public int execute(boolean async, CommandLine command, ExecuteResultHandler handler) throws IOException {
        return this.execute(async, command, null, null, null, handler);
    }

    @Override
    public int execute(CommandLine command, Map<String, String> environment, File workingDirectory, ExecuteStreamHandler streamHandler, ExecuteResultHandler handler) throws ExecuteException, IOException {
        return this.execute(false, command, environment, workingDirectory, streamHandler, handler);
    }

    @Override
    public int execute(boolean async, final CommandLine command, final Map<String, String> environment, File workingDir, ExecuteStreamHandler executeStreamHandler, ExecuteResultHandler resultHandler) throws IOException {
        CompletableFuture<Integer> future;
        if (this.watchdog != null) {
            this.watchdog.setProcessNotStarted();
        }
        final ExecuteStreamHandler streamHandler = Objs.useValueIfNull(executeStreamHandler, this.streamHandler);
        final File workingDirectory = Objs.useValueIfNull(workingDir, this.getWorkingDirectory());
        final ExecuteResultHandler executeResultHandler = Objs.useValueIfNull(resultHandler, this.resultHandler);
        Supplier0<Integer> task = new Supplier0<Integer>(){

            @Override
            public Integer get() {
                return DefaultCommandLineExecutor.this.doExecute(command, environment, workingDirectory, streamHandler, executeResultHandler);
            }
        };
        CompletableFuture<Integer> completableFuture = future = this.executorService == null ? CompletableFuture.supplyAsync(task) : CompletableFuture.supplyAsync(task, this.executorService);
        if (!async) {
            try {
                return (Integer)((CompletableFuture)future.exceptionally((Function)new Function<Throwable, Integer>(){

                    @Override
                    public Integer apply(Throwable ex) {
                        DefaultCommandLineExecutor.this.setExceptionCaught(ex);
                        return -1;
                    }
                })).get();
            }
            catch (Throwable ex) {
                throw Throwables.wrapAsRuntimeException(ex);
            }
        }
        return -1;
    }

    private int doExecute(CommandLine command, Map<String, String> environment, File workingDir, ExecuteStreamHandler executeStreamHandler, ExecuteResultHandler resultHandler) {
        int exitValue = -559038737;
        try {
            exitValue = this.executeInternal(command, environment, this.workingDirectory, this.streamHandler);
            resultHandler.onProcessComplete(exitValue);
        }
        catch (ExecuteException e) {
            resultHandler.onProcessFailed(e);
        }
        catch (Exception e) {
            resultHandler.onProcessFailed(new ExecuteException("Execution failed", exitValue, e));
        }
        return exitValue;
    }

    @Override
    public void setExitValue(int value) {
        this.setExitValues(new int[]{value});
    }

    @Override
    public void setExitValues(int[] values) {
        this.exitValues = values == null ? null : (int[])values.clone();
    }

    @Override
    public boolean isFailure(int exitValue) {
        if (this.exitValues == null) {
            return false;
        }
        if (this.exitValues.length == 0) {
            return this.launcher.isFailure(exitValue);
        }
        for (int exitValue2 : this.exitValues) {
            if (exitValue2 != exitValue) continue;
            return false;
        }
        return true;
    }

    protected InstructionSequence launch(CommandLine command, Map<String, String> env, File workingDir) throws IOException {
        if (this.launcher == null) {
            throw new IllegalStateException("CommandLauncher can not be null");
        }
        if (workingDir == null) {
            throw new IOException(" the work directory is not exist.");
        }
        if (this.launcher instanceof LocalCommandLauncher && !workingDir.exists()) {
            throw new IOException(workingDir + " doesn't exist.");
        }
        return this.launcher.exec(command, env, workingDir);
    }

    private void closeProcessStreams(InstructionSequence process) {
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            this.setExceptionCaught(e);
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            this.setExceptionCaught(e);
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException e) {
            this.setExceptionCaught(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeInternal(CommandLine command, Map<String, String> environment, File dir, ExecuteStreamHandler streamHandler) throws IOException {
        this.setExceptionCaught(null);
        InstructionSequence process = this.launch(command, environment, dir);
        try {
            streamHandler.setSubProcessInputStream(process.getOutputStream());
            streamHandler.setSubProcessOutputStream(process.getInputStream());
            streamHandler.setSubProcessErrorStream(process.getErrorStream());
        }
        catch (IOException e) {
            process.destroy();
            throw e;
        }
        streamHandler.start();
        try {
            if (this.getProcessDestroyer() != null) {
                this.getProcessDestroyer().add(process);
            }
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            int exitValue = -559038737;
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                process.destroy();
            }
            finally {
                if (process instanceof ProcessAdapter) {
                    Thread.interrupted();
                }
            }
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            try {
                streamHandler.stop();
            }
            catch (IOException e) {
                this.setExceptionCaught(e);
            }
            this.closeProcessStreams(process);
            if (this.getExceptionCaught() != null) {
                throw Throwables.wrapAsRuntimeException(this.getExceptionCaught());
            }
            if (this.watchdog != null) {
                try {
                    this.watchdog.checkException();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (this.isFailure(exitValue)) {
                throw new ExecuteException("Process exited with an error: " + exitValue, exitValue);
            }
            int n = exitValue;
            return n;
        }
        finally {
            if (this.getProcessDestroyer() != null) {
                try {
                    this.getProcessDestroyer().remove(process);
                }
                catch (Throwable ex) {
                    this.logger.error(ex.getMessage(), ex);
                }
            }
            if (this.watchdog != null) {
                try {
                    this.watchdog.stop();
                }
                catch (Throwable ex) {
                    this.logger.error(ex.getMessage(), ex);
                }
            } else {
                try {
                    process.destroy();
                }
                catch (Throwable ex) {
                    this.logger.error(ex.getMessage(), ex);
                }
            }
        }
    }

    private void setExceptionCaught(Throwable e) {
        if (this.exceptionCaught == null) {
            this.exceptionCaught = e;
        }
    }

    private Throwable getExceptionCaught() {
        return this.exceptionCaught;
    }
}

