/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.commandline;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.commandline.CommandLine;
import com.jn.langx.commandline.DefaultCommandLineExecutor;
import com.jn.langx.commandline.streamhandler.OutputAsStringExecuteStreamHandler;
import com.jn.langx.commandline.streamhandler.OutputLinesExecuteStreamHandler;
import com.jn.langx.util.Preconditions;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLines {
    private static final Logger logger = LoggerFactory.getLogger(CommandLines.class);

    private CommandLines() {
    }

    public static List<String> executeAndReadLines(@NonNull CommandLine commandLine, @Nullable File workDirectory, @Nullable Map<String, String> environment) {
        Preconditions.checkNotEmpty(commandLine, "the command line is null or empty");
        DefaultCommandLineExecutor executor = new DefaultCommandLineExecutor();
        if (workDirectory != null) {
            executor.setWorkingDirectory(workDirectory);
        }
        OutputLinesExecuteStreamHandler h = new OutputLinesExecuteStreamHandler();
        executor.setStreamHandler(h);
        try {
            executor.execute(commandLine, environment);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
        }
        return (List)h.getOutputContent();
    }

    public static String executeAndReadAsString(@NonNull CommandLine commandLine, @Nullable File workDirectory, @Nullable Map<String, String> environment) {
        Preconditions.checkNotEmpty(commandLine, "the command line is null or empty");
        DefaultCommandLineExecutor executor = new DefaultCommandLineExecutor();
        if (workDirectory != null) {
            executor.setWorkingDirectory(workDirectory);
        }
        OutputAsStringExecuteStreamHandler h = new OutputAsStringExecuteStreamHandler();
        executor.setStreamHandler(h);
        try {
            executor.execute(commandLine, environment);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
        }
        return (String)h.getOutputContent();
    }
}

