/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.codec.hex;

import com.jn.langx.codec.CodecException;
import com.jn.langx.util.io.Charsets;

public class Hex {
    private static final char[] DECIMAL_TO_DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DECIMAL_TO_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] decodeHex(String data) {
        return Hex.decodeHex(data.toCharArray());
    }

    public static byte[] decodeHex(char[] data) throws CodecException {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new CodecException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDecimal(data[j], j) << 4;
            f |= Hex.toDecimal(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static byte[] encodeHexAsBytes(String data) {
        return Hex.encodeHexAsBytes(data, true);
    }

    public static byte[] encodeHexAsBytes(String data, boolean toLowerCase) {
        String hex = Hex.encodeHexToString(data, toLowerCase);
        return hex.getBytes(Charsets.UTF_8);
    }

    public static String encodeHexToString(String data) {
        return Hex.encodeHexToString(data, true);
    }

    public static String encodeHexToString(String data, boolean toLowerCase) {
        return new String(Hex.encodeHex(data, toLowerCase));
    }

    public static char[] encodeHex(String data) {
        return Hex.encodeHex(data, true);
    }

    public static char[] encodeHex(String data, boolean toLowerCase) {
        return Hex.encodeHex(data.getBytes(Charsets.UTF_8), toLowerCase);
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Hex.encodeHex(data, toLowerCase ? DECIMAL_TO_DIGITS_LOWER : DECIMAL_TO_DIGITS_UPPER);
    }

    private static final char[] encodeHex(byte[] data, char[] toDigits) {
        int length = data.length;
        char[] out = new char[length << 1];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return Hex.encodeHexString(data, true);
    }

    public static String encodeHexString(byte[] data, boolean lowerCase) {
        return new String(Hex.encodeHex(data, lowerCase));
    }

    private static int toDecimal(char ch, int index) throws CodecException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new CodecException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

