/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.scanner;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentDetection {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentDetection.class);
    private ClassLoader classLoader;
    private Boolean jbossVFSv2;
    private Boolean jbossVFSv3;
    private Boolean osgi;

    public EnvironmentDetection(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isJBossVFSv2() {
        if (this.jbossVFSv2 == null) {
            this.jbossVFSv2 = EnvironmentDetection.isPresent("org.jboss.virtual.VFS", this.classLoader);
            logger.trace("... JBoss VFS v2 available: {}", (Object)this.jbossVFSv2);
        }
        return this.jbossVFSv2;
    }

    public boolean isJBossVFSv3() {
        if (this.jbossVFSv3 == null) {
            this.jbossVFSv3 = EnvironmentDetection.isPresent("org.jboss.vfs.VFS", this.classLoader);
            logger.trace("... JBoss VFS v3 available: {}", (Object)this.jbossVFSv3);
        }
        return this.jbossVFSv3;
    }

    public boolean isOsgi() {
        if (this.osgi == null) {
            this.osgi = EnvironmentDetection.isPresent("org.osgi.framework.Bundle", this.classLoader);
            logger.trace("... OSGi framework available: {}", (Object)this.osgi);
        }
        return this.osgi;
    }

    protected static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

