/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.cp;

import com.jn.langx.classpath.ClassFile;
import com.jn.langx.classpath.Classpath;
import com.jn.langx.classpath.Classpaths;
import com.jn.langx.classpath.ResourceClassFile;
import com.jn.langx.classpath.ResourceFilter;
import com.jn.langx.io.resource.Location;
import com.jn.langx.io.resource.Locations;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import java.util.List;
import java.util.Set;

public abstract class AbstractClasspath
implements Classpath {
    @Override
    public ClassFile findClassFile(String classname) {
        Resource resource = this.findResource(Classpaths.classNameToPath(classname));
        if (resource == null) {
            return null;
        }
        return new ResourceClassFile(resource);
    }

    @Override
    public List<ClassFile> scanClassFiles(String packageName, ResourceFilter filter) {
        List<Resource> resources = this.scanResources(packageName, filter);
        return Pipeline.of(resources).map(new Function<Resource, ClassFile>(){

            @Override
            public ClassFile apply(Resource resource) {
                if (resource == null) {
                    return null;
                }
                return new ResourceClassFile(resource);
            }
        }).clearNulls().asList();
    }

    @Override
    public List<Resource> scanResources(String namespace, ResourceFilter filter) {
        namespace = Classpaths.getCanonicalFilePath(namespace);
        Set<Location> locations = this.scanResourceLocations(namespace, filter);
        final Location root = this.getRoot();
        return Pipeline.of(locations).map(new Function<Location, Resource>(){

            @Override
            public Resource apply(Location location) {
                String relativePath = Locations.getRelativePath(root, location);
                if (relativePath == null) {
                    return null;
                }
                return AbstractClasspath.this.findResource(relativePath);
            }
        }).clearNulls().asList();
    }

    @Override
    public Set<Location> scanResourceLocations(String namespace, ResourceFilter filter) {
        Pipeline<Location> pipeline = Pipeline.of(this.allResources());
        final Location root = this.getRoot();
        final Location namespaceLocation = Locations.newLocation(root, namespace);
        if (Emptys.isNotEmpty(namespace)) {
            pipeline = pipeline.filter(new Predicate<Location>(){

                @Override
                public boolean test(Location location) {
                    return Locations.getRelativePath(root, namespaceLocation) != null;
                }
            });
        }
        if (filter != null) {
            pipeline = pipeline.filter(filter);
        }
        return pipeline.asSet(true);
    }

    @Override
    public abstract Set<Location> allResources();
}

