/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.classloader;

import com.jn.langx.classpath.classloader.ClassLoaderAccessor;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionIgnoringAccessor
implements ClassLoaderAccessor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionIgnoringAccessor.class);

    @Override
    public Class loadClass(String fqcn) {
        Class<?> clazz;
        block3: {
            clazz = null;
            ClassLoader cl = this.getClassLoader();
            if (cl != null) {
                try {
                    clazz = Class.forName(fqcn, false, cl);
                }
                catch (ClassNotFoundException e) {
                    if (!log.isTraceEnabled()) break block3;
                    log.trace("Unable to load clazz named [" + fqcn + "] from class loader [" + cl + "]");
                }
            }
        }
        return clazz;
    }

    @Override
    public InputStream getResourceStream(String name) {
        InputStream is = null;
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            is = cl.getResourceAsStream(name);
        }
        return is;
    }

    protected final ClassLoader getClassLoader() {
        try {
            return this.doGetClassLoader();
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to acquire ClassLoader.", t);
            }
            return null;
        }
    }

    protected abstract ClassLoader doGetClassLoader() throws Throwable;
}

