/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.cache;

import com.jn.langx.annotation.Unreleased;
import com.jn.langx.cache.AbstractCache;
import com.jn.langx.cache.Entry;
import com.jn.langx.cache.RemoveCause;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.timing.timer.Timer;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

@Unreleased
class LFUCache<K, V>
extends AbstractCache<K, V> {
    private TreeMap<K, Long> lastUsedTimeSortedMap = new TreeMap(new Comparator<K>(){

        @Override
        public int compare(K o1, K o2) {
            return 0;
        }
    });

    public LFUCache() {
        super(Integer.MAX_VALUE, 60000L);
    }

    public LFUCache(int maxCapacity, long evictExpiredInterval) {
        super(maxCapacity, evictExpiredInterval);
    }

    public LFUCache(int maxCapacity, long evictExpiredInterval, Timer timer) {
        super(maxCapacity, evictExpiredInterval, timer);
    }

    @Override
    protected void addToCache(Entry<K, V> entry) {
        Object key = entry.getKey();
        if (key != null) {
            this.lastUsedTimeSortedMap.put(key, entry.getLastUsedTime());
        }
    }

    @Override
    protected void removeFromCache(Entry<K, V> entry, RemoveCause removeCause) {
        Object key = entry.getKey();
        if (key != null) {
            this.lastUsedTimeSortedMap.remove(entry.getKey());
        }
    }

    @Override
    protected void beforeRecomputeExpireTimeOnRead(Entry<K, V> entry) {
    }

    @Override
    protected void afterRecomputeExpireTimeOnRead(Entry<K, V> entry) {
    }

    @Override
    protected void beforeRead(Entry<K, V> entry) {
        this.removeFromCache(entry, null);
    }

    @Override
    protected void afterRead(Entry<K, V> entry) {
        this.addToCache(entry);
    }

    @Override
    protected List<K> forceEvict(int count) {
        return Pipeline.of(this.lastUsedTimeSortedMap.keySet()).findN(count).asList();
    }
}

