/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.cache;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.reflect.reference.ReferenceEntry;
import com.jn.langx.util.reflect.reference.ReferenceType;
import com.jn.langx.util.struct.Reference;
import java.lang.ref.ReferenceQueue;

public class Entry<K, V>
extends ReferenceEntry<K, V> {
    private long expireTime = Long.MAX_VALUE;
    private long lastReadTime;
    private long lastWriteTime;
    private long lastUsedTime;
    private int usedCountFromLastEvict;
    private int age = 0;

    Entry(K key, ReferenceType keyReferenceType, V value, ReferenceType valueReferenceType, ReferenceQueue referenceQueue, boolean wrappedWhenStrong, long expireTime) {
        super(key, keyReferenceType, value, valueReferenceType, referenceQueue, wrappedWhenStrong);
        this.setExpireTime(expireTime);
    }

    Entry(K key, V value, boolean wrappedWhenStrong, long expireTime) {
        this(key, ReferenceType.STRONG, value, ReferenceType.STRONG, null, wrappedWhenStrong, expireTime);
    }

    @Override
    public V getValue() {
        return this.getValue(true);
    }

    public V getValue(boolean updateTime) {
        if (updateTime) {
            this.lastUsedTime = this.lastReadTime = System.currentTimeMillis();
        }
        return super.getValue();
    }

    @Override
    public void setValue(V value) {
        Preconditions.checkNotNull(value);
        this.lastUsedTime = this.lastWriteTime = System.currentTimeMillis();
        super.setValue(value);
        this.age = 0;
    }

    public int getAge() {
        return this.age;
    }

    public void incrementAge() {
        ++this.age;
    }

    public void incrementUseCount() {
        ++this.usedCountFromLastEvict;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.expireTime;
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public void setLastReadTime(long lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    public void setLastWriteTime(long lastWriteTime) {
        this.lastWriteTime = lastWriteTime;
    }

    public void setLastUsedTime(long lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Entry entry = (Entry)object;
        return this.keyRef.equals(entry.keyRef);
    }

    public int hashCode() {
        if (this.keyRef != null) {
            if (this.keyRef instanceof Reference) {
                return ((Reference)this.keyRef).getHash();
            }
            return this.keyRef.hashCode();
        }
        return 0;
    }
}

