/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.beans.propertyeditor;

import com.jn.langx.text.i18n.LocaleCode;
import java.beans.PropertyEditorSupport;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateEditor
extends PropertyEditorSupport {
    private static DateFormat[] formats;
    private String text;

    public static void initialize() {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                String defaultFormat = System.getProperty("com.jn.langx.beans.propertyeditor.DateEditor.format", "MMM d, yyyy");
                String defaultLocale = System.getProperty("com.jn.langx.beans.propertyeditor.DateEditor.locale");
                SimpleDateFormat defaultDateFormat = defaultLocale == null || defaultLocale.length() == 0 ? new SimpleDateFormat(defaultFormat) : new SimpleDateFormat(defaultFormat, LocaleCode.getByCode(defaultLocale).toLocale());
                DateEditor.access$002(new DateFormat[]{defaultDateFormat, new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z")});
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Date) && value != null) {
            throw new IllegalArgumentException("setValue() expected java.util.Date value, got " + value.getClass().getName());
        }
        this.text = null;
        super.setValue(value);
    }

    @Override
    public void setAsText(String text) {
        ParseException pe = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                DateFormat df = formats[i];
                Date date = df.parse(text);
                this.text = text;
                super.setValue(date);
                return;
            }
            catch (ParseException e) {
                pe = e;
                continue;
            }
        }
        throw new RuntimeException(pe);
    }

    @Override
    public String getAsText() {
        if (this.text == null) {
            DateFormat df = formats[formats.length - 1];
            Date date = (Date)this.getValue();
            this.text = df.format(date);
        }
        return this.text;
    }

    static /* synthetic */ DateFormat[] access$002(DateFormat[] x0) {
        formats = x0;
        return x0;
    }

    static {
        DateEditor.initialize();
    }
}

