/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;

public class CoreEventListenerList {
    private List<ICoreEventListener> listeners;

    public CoreEventListenerList(ICoreEventListener listener) {
        this.listeners = new ArrayList<ICoreEventListener>(4);
        this.listeners.add(listener);
    }

    public CoreEventListenerList(ICoreEventListener[] listeners) {
        this.listeners = new ArrayList<ICoreEventListener>(listeners.length);
        this.listeners.addAll(Arrays.asList(listeners));
    }

    public void add(ICoreEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<ICoreEventListener>(4);
        }
        this.listeners.add(listener);
    }

    public void remove(ICoreEventListener listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners == null || this.listeners.isEmpty();
    }

    public void fireCoreEvent(CoreEvent e) {
        Object[] list;
        if (this.listeners == null) {
            return;
        }
        for (Object listener : list = this.listeners.toArray()) {
            ((ICoreEventListener)listener).handleCoreEvent(e);
        }
    }

    public boolean hasListener(ICoreEventListener listener) {
        return this.listeners != null && this.listeners.contains(listener);
    }
}

