/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.ICloneData;
import org.xmind.core.IManifest;
import org.xmind.core.IMeta;
import org.xmind.core.INotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.IResourceRef;
import org.xmind.core.IRevisionRepository;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbookComponentRefManager;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Workbook;
import org.xmind.core.internal.dom.BaseNotesContentImpl;
import org.xmind.core.internal.dom.BoundaryImpl;
import org.xmind.core.internal.dom.HtmlNotesContentImpl;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerRefImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.NodeAdaptableRegistry;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.PlainNotesContentImpl;
import org.xmind.core.internal.dom.RelationshipImpl;
import org.xmind.core.internal.dom.ResourceRefImpl;
import org.xmind.core.internal.dom.RevisionRepositoryImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.SummaryImpl;
import org.xmind.core.internal.dom.TempSaver;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.internal.dom.WorkbookComponentRefCounter;
import org.xmind.core.internal.dom.WorkbookMarkerRefCounter;
import org.xmind.core.internal.dom.WorkbookMarkerResourceProvider;
import org.xmind.core.internal.dom.WorkbookSaver;
import org.xmind.core.internal.dom.WorkbookStyleRefCounter;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.IMarkerRefCounter;
import org.xmind.core.util.IStyleRefCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookImpl
extends Workbook
implements ICoreEventSource,
ICoreEventSource2,
INodeAdaptableFactory {
    private Document implementation;
    private WorkbookSaver saver;
    private TempSaver tempSaver;
    private NodeAdaptableRegistry adaptableRegistry;
    private CoreEventSupport coreEventSupport = null;
    private StyleSheetImpl styleSheet = null;
    private ManifestImpl manifest = null;
    private MarkerSheetImpl markerSheet = null;
    private MetaImpl meta = null;
    private WorkbookMarkerRefCounter markerRefCounter = null;
    private WorkbookStyleRefCounter styleRefCounter = null;
    private WorkbookComponentRefCounter elementRefCounter = null;
    private String password = null;
    private RevisionRepositoryImpl revisionRepository = null;

    public WorkbookImpl(Document implementation) {
        this(implementation, null, true);
    }

    public WorkbookImpl(Document implementation, String targetPath) {
        this(implementation, targetPath, true);
    }

    public WorkbookImpl(Document implementation, String targetPath, boolean needInit) {
        this.implementation = implementation;
        this.saver = new WorkbookSaver(this, targetPath);
        this.tempSaver = new TempSaver(this);
        this.adaptableRegistry = new NodeAdaptableRegistry(implementation, this);
        if (needInit) {
            this.init();
        }
    }

    private void init() {
        Element w = DOMUtils.ensureChildElement(this.implementation, "xmap-content");
        NS.setNS(NS.XMAP, w, NS.Xhtml, NS.Xlink, NS.SVG, NS.Fo);
        if (!DOMUtils.childElementIterByTag(w, "sheet").hasNext()) {
            this.addSheet(this.createSheet());
        }
        InternalDOMUtils.addVersion(this.implementation);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof WorkbookImpl)) {
            return false;
        }
        WorkbookImpl that = (WorkbookImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        if (this.getFile() != null) {
            return "Workbook(" + this.getFile() + ")";
        }
        return "Workbook{" + this.hashCode() + "}";
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Document.class || adapter == Node.class) {
            return this.implementation;
        }
        if (adapter == IMarkerSheet.class) {
            return this.getMarkerSheet();
        }
        if (adapter == IManifest.class) {
            return this.getManifest();
        }
        if (adapter == ICoreEventSupport.class) {
            return this.getCoreEventSupport();
        }
        if (adapter == INodeAdaptableFactory.class) {
            return this;
        }
        if (adapter == INodeAdaptableProvider.class) {
            return this.getAdaptableRegistry();
        }
        if (adapter == IMarkerRefCounter.class) {
            return this.getMarkerRefCounter();
        }
        if (adapter == IStyleRefCounter.class) {
            return this.getStyleRefCounter();
        }
        if (adapter == IWorkbookComponentRefManager.class) {
            return this.getElementRefCounter();
        }
        if (adapter == IRevisionRepository.class) {
            return this.getRevisionRepository();
        }
        return super.getAdapter(adapter);
    }

    protected Element getWorkbookElement() {
        return this.implementation.getDocumentElement();
    }

    public NodeAdaptableRegistry getAdaptableRegistry() {
        return this.adaptableRegistry;
    }

    @Override
    public ITopic createTopic() {
        TopicImpl topic = new TopicImpl(this.implementation.createElement("topic"), this);
        this.getAdaptableRegistry().registerByNode(topic, topic.getImplementation());
        return topic;
    }

    @Override
    public ISheet createSheet() {
        SheetImpl sheet = new SheetImpl(this.implementation.createElement("sheet"), this);
        this.getAdaptableRegistry().registerByNode(sheet, sheet.getImplementation());
        return sheet;
    }

    @Override
    public IRelationship createRelationship() {
        RelationshipImpl relationship = new RelationshipImpl(this.implementation.createElement("relationship"), this);
        this.getAdaptableRegistry().registerByNode(relationship, relationship.getImplementation());
        return relationship;
    }

    @Override
    public IRelationship createRelationship(IRelationshipEnd end1, IRelationshipEnd end2) {
        ISheet sheet = end1.getOwnedSheet();
        IRelationship rel = this.createRelationship();
        rel.setEnd1Id(end1.getId());
        rel.setEnd2Id(end2.getId());
        sheet.addRelationship(rel);
        return rel;
    }

    @Override
    public IBoundary createBoundary() {
        BoundaryImpl boundary = new BoundaryImpl(this.implementation.createElement("boundary"), this);
        this.getAdaptableRegistry().registerByNode(boundary, boundary.getImplementation());
        return boundary;
    }

    @Override
    public ISummary createSummary() {
        SummaryImpl summary = new SummaryImpl(this.implementation.createElement("summary"), this);
        this.getAdaptableRegistry().registerByNode(summary, summary.getImplementation());
        return summary;
    }

    @Override
    public INotesContent createNotesContent(String format) {
        Element e = this.implementation.createElement(format);
        BaseNotesContentImpl content = "html".equals(format) ? new HtmlNotesContentImpl(e, this) : new PlainNotesContentImpl(e, this);
        this.getAdaptableRegistry().registerByNode(content, e);
        return content;
    }

    @Override
    public String getVersion() {
        return DOMUtils.getAttribute(this.getWorkbookElement(), "version");
    }

    private void saveVersion() {
        InternalDOMUtils.replaceVersion(this.implementation);
        InternalDOMUtils.replaceVersion(((MetaImpl)this.getMeta()).getImplementation());
        if (this.styleSheet != null) {
            InternalDOMUtils.replaceVersion(this.styleSheet.getImplementation());
        }
        if (this.markerSheet != null) {
            InternalDOMUtils.replaceVersion(this.markerSheet.getImplementation());
        }
    }

    @Override
    public List<ISheet> getSheets() {
        return DOMUtils.getChildList(this.getWorkbookElement(), "sheet", this.getAdaptableRegistry());
    }

    @Override
    public ISheet getPrimarySheet() {
        Element e = DOMUtils.getFirstChildElementByTag(this.getWorkbookElement(), "sheet");
        if (e != null) {
            return (ISheet)this.getAdaptableRegistry().getAdaptable(e);
        }
        return null;
    }

    @Override
    public void addSheet(ISheet sheet, int index) {
        Element s = ((SheetImpl)sheet).getImplementation();
        if (s != null && s.getOwnerDocument() == this.implementation) {
            Element w = this.getWorkbookElement();
            Node n = null;
            Element[] es = DOMUtils.getChildElementsByTag(w, "sheet");
            n = index >= 0 && index < es.length ? w.insertBefore(s, es[index]) : w.appendChild(s);
            if (n != null) {
                ((SheetImpl)sheet).addNotify(this);
                this.fireIndexedTargetChange("sheetAdd", sheet, sheet.getIndex());
                this.updateModifiedTime();
            }
        }
    }

    @Override
    public void removeSheet(ISheet sheet) {
        Element s = ((SheetImpl)sheet).getImplementation();
        Element w = this.getWorkbookElement();
        if (s != null && s.getParentNode() == w) {
            int oldIndex = sheet.getIndex();
            ((SheetImpl)sheet).removeNotify(this);
            Node n = w.removeChild(s);
            if (n != null) {
                this.fireIndexedTargetChange("sheetRemove", sheet, oldIndex);
                this.updateModifiedTime();
            }
        }
    }

    @Override
    public void moveSheet(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0 || sourceIndex == targetIndex) {
            return;
        }
        Element w = this.getWorkbookElement();
        Element[] ss = DOMUtils.getChildElementsByTag(w, "sheet");
        if (sourceIndex >= ss.length) {
            return;
        }
        Element s = ss[sourceIndex];
        if (targetIndex >= 0 && targetIndex < ss.length - 1) {
            int realTargetIndex = sourceIndex < targetIndex ? targetIndex + 1 : targetIndex;
            Element target = ss[realTargetIndex];
            if (s != target) {
                w.removeChild(s);
                w.insertBefore(s, target);
            }
        } else {
            w.removeChild(s);
            w.appendChild(s);
            targetIndex = ss.length - 1;
        }
        if (sourceIndex != targetIndex) {
            this.fireIndexedTargetChange("sheetMove", this.getAdaptableRegistry().getAdaptable(s), sourceIndex);
            this.updateModifiedTime();
        }
    }

    @Override
    public IStyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            this.styleSheet = this.createStyleSheet();
        }
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheetImpl styleSheet) {
        this.styleSheet = styleSheet;
    }

    protected StyleSheetImpl createStyleSheet() {
        StyleSheetImpl ss = (StyleSheetImpl)Core.getStyleSheetBuilder().createStyleSheet();
        ss.setManifest(this.getManifest());
        return ss;
    }

    @Override
    public IManifest getManifest() {
        if (this.manifest == null) {
            this.manifest = this.createManifest();
        }
        return this.manifest;
    }

    public void setManifest(ManifestImpl manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException("Manifest is null");
        }
        ManifestImpl oldManifest = this.manifest;
        this.manifest = manifest;
        if (oldManifest != null) {
            oldManifest.setWorkbook(null);
        }
        manifest.setWorkbook(this);
    }

    protected ManifestImpl createManifest() {
        Document mfImpl = this.createManifestImplementation();
        ManifestImpl mf = new ManifestImpl(mfImpl);
        mf.setWorkbook(this);
        mf.createFileEntry("content.xml", "text/xml").increaseReference();
        mf.createFileEntry("META-INF/manifest.xml", "text/xml").increaseReference();
        mf.createFileEntry("meta.xml", "text/xml").increaseReference();
        return mf;
    }

    private Document createManifestImplementation() {
        return DOMUtils.createDocument("manifest");
    }

    @Override
    public IMarkerSheet getMarkerSheet() {
        if (this.markerSheet == null) {
            this.markerSheet = this.createMarkerSheet();
        }
        return this.markerSheet;
    }

    protected MarkerSheetImpl createMarkerSheet() {
        return (MarkerSheetImpl)Core.getMarkerSheetBuilder().createMarkerSheet(new WorkbookMarkerResourceProvider(this));
    }

    public void setMarkerSheet(MarkerSheetImpl markerSheet) {
        this.markerSheet = markerSheet;
    }

    @Override
    public IMeta getMeta() {
        if (this.meta == null) {
            this.meta = this.createMeta();
        }
        return this.meta;
    }

    private MetaImpl createMeta() {
        Document metaImpl = DOMUtils.createDocument();
        MetaImpl meta = new MetaImpl(metaImpl);
        meta.setOwnedWorkbook(this);
        return meta;
    }

    public void setMeta(MetaImpl meta) {
        if (meta == null) {
            throw new IllegalArgumentException("Meta is null");
        }
        MetaImpl oldMeta = this.meta;
        this.meta = meta;
        if (oldMeta != null) {
            oldMeta.setOwnedWorkbook(null);
        }
        meta.setOwnedWorkbook(this);
    }

    protected WorkbookMarkerRefCounter getMarkerRefCounter() {
        if (this.markerRefCounter == null) {
            this.markerRefCounter = new WorkbookMarkerRefCounter((MarkerSheetImpl)this.getMarkerSheet(), (ManifestImpl)this.getManifest());
        }
        return this.markerRefCounter;
    }

    protected WorkbookStyleRefCounter getStyleRefCounter() {
        if (this.styleRefCounter == null) {
            this.styleRefCounter = new WorkbookStyleRefCounter((StyleSheetImpl)this.getStyleSheet(), (ManifestImpl)this.getManifest());
        }
        return this.styleRefCounter;
    }

    protected WorkbookComponentRefCounter getElementRefCounter() {
        if (this.elementRefCounter == null) {
            this.elementRefCounter = new WorkbookComponentRefCounter(this);
        }
        return this.elementRefCounter;
    }

    @Override
    public IRevisionRepository getRevisionRepository() {
        if (this.revisionRepository == null) {
            this.revisionRepository = new RevisionRepositoryImpl(this);
        }
        return this.revisionRepository;
    }

    @Override
    public ICloneData clone(Collection<? extends Object> sources) {
        return WorkbookUtilsImpl.clone(this, sources, null);
    }

    @Override
    public IAdaptable importElement(IAdaptable source) {
        Node node = (Node)source.getAdapter(Node.class);
        if (node == null) {
            return null;
        }
        Node ele = this.getImplementation().importNode(node, true);
        return this.getAdaptableRegistry().getAdaptable(ele);
    }

    @Override
    public IResourceRef createResourceRef(String resourceType, String resourceId) {
        Element ele = this.implementation.createElement("resource-ref");
        ele.setAttribute("type", resourceType);
        ele.setAttribute("resource-id", resourceId);
        ResourceRefImpl ref = new ResourceRefImpl(ele, this);
        this.getAdaptableRegistry().registerByNode(ref, ele);
        return ref;
    }

    @Override
    public Object findElement(String id, IAdaptable source) {
        Node node;
        Node node2 = node = source == null ? null : (Node)source.getAdapter(Node.class);
        if (node == null) {
            node = this.getImplementation();
        }
        return this.getAdaptableRegistry().getAdaptable(id, DOMUtils.getOwnerDocument(node));
    }

    @Override
    public IAdaptable createAdaptable(Node node) {
        if (node instanceof Element) {
            String parentName;
            Element e = (Element)node;
            String tagName = e.getNodeName();
            if ("sheet".equals(tagName)) {
                return new SheetImpl(e, this);
            }
            if ("topic".equals(tagName)) {
                return new TopicImpl(e, this);
            }
            if ("relationship".equals(tagName)) {
                return new RelationshipImpl(e, this);
            }
            if ("marker-ref".equals(tagName)) {
                return new MarkerRefImpl(e, this);
            }
            if ("boundary".equals(tagName)) {
                return new BoundaryImpl(e, this);
            }
            if ("summary".equals(tagName)) {
                return new SummaryImpl(e, this);
            }
            if ("resource-ref".equals(tagName)) {
                return new ResourceRefImpl(e, this);
            }
            Node p = node.getParentNode();
            if (p != null && p instanceof Element && "notes".equals(parentName = p.getNodeName())) {
                String format = tagName;
                if ("html".equals(format)) {
                    return new HtmlNotesContentImpl(e, this);
                }
                if ("plain".equals(format)) {
                    return new PlainNotesContentImpl(e, this);
                }
            }
        }
        return null;
    }

    @Override
    public void setPassword(String password) {
        String oldPassword = this.password;
        this.password = password;
        this.fireValueChange("passwordChange", oldPassword, this.password);
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    private void fireValueChange(String type, Object oldValue, Object newValue) {
        ICoreEventSupport coreEventSupport = this.getCoreEventSupport();
        if (coreEventSupport != null) {
            coreEventSupport.dispatchValueChange(this, type, oldValue, newValue);
        }
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport == null) {
            this.coreEventSupport = new CoreEventSupport();
        }
        return this.coreEventSupport;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public ICoreEventRegistration registerOnceCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerOnceCoreEventListener(this, type, listener);
    }

    @Override
    public boolean hasOnceListeners(String type) {
        return this.coreEventSupport != null && this.coreEventSupport.hasOnceListeners(this, type);
    }

    private void fireIndexedTargetChange(String type, Object target, int index) {
        if (this.coreEventSupport != null) {
            this.coreEventSupport.dispatchIndexedTargetChange(this, type, target, index);
        }
    }

    private void fireTargetChange(String type, Object target) {
        if (this.coreEventSupport != null) {
            this.coreEventSupport.dispatchTargetChange(this, type, target);
        }
    }

    private void save(ISaveable runnable) throws IOException, CoreException {
        this.saveVersion();
        this.fireTargetChange("workbookPreSaveOnce", this);
        this.fireTargetChange("workbookPreSave", this);
        runnable.run();
        this.fireTargetChange("workbookSave", this);
    }

    @Override
    public synchronized void save() throws IOException, CoreException {
        this.save(new ISaveable(){

            public void run() throws IOException, CoreException {
                WorkbookImpl.this.saver.save();
            }
        });
    }

    @Override
    public synchronized void save(final String file) throws IOException, CoreException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.save(new ISaveable(){

            public void run() throws IOException, CoreException {
                WorkbookImpl.this.saver.save(file);
            }
        });
    }

    @Override
    public synchronized void save(final IOutputTarget target) throws IOException, CoreException {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.save(new ISaveable(){

            public void run() throws IOException, CoreException {
                WorkbookImpl.this.saver.save(target);
            }
        });
    }

    @Override
    public synchronized void save(final OutputStream output) throws IOException, CoreException {
        if (output == null) {
            throw new IllegalArgumentException();
        }
        this.save(new ISaveable(){

            public void run() throws IOException, CoreException {
                WorkbookImpl.this.saver.save(output);
            }
        });
    }

    @Override
    public void setTempStorage(IStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException();
        }
        this.tempSaver.setStorage(storage);
    }

    @Override
    public IStorage getTempStorage() {
        return this.tempSaver.getStorage();
    }

    @Override
    public String getFile() {
        return this.saver.getFile();
    }

    @Override
    public void setFile(String file) {
        this.saver.setFile(file);
    }

    public void setSkipRevisionsWhenSaving(boolean skipRevisions) {
        this.saver.setSkipRevisions(skipRevisions);
    }

    public boolean isSkipRevisionsWhenSaving() {
        return this.saver.isSkipRevisions();
    }

    @Override
    public String getTempLocation() {
        IStorage storage = this.getTempStorage();
        return storage instanceof DirectoryStorage ? ((DirectoryStorage)storage).getFullPath() : null;
    }

    @Override
    public void setTempLocation(String tempLocation) {
        if (tempLocation == null) {
            throw new IllegalArgumentException();
        }
        this.setTempStorage(new DirectoryStorage(new File(tempLocation)));
    }

    @Override
    public void saveTemp() throws IOException, CoreException {
        this.tempSaver.save();
    }

    @Override
    public long getModifiedTime() {
        String time = DOMUtils.getAttribute(this.getWorkbookElement(), "timestamp");
        return NumberUtils.safeParseLong(time, 0L);
    }

    public void updateModifiedTime() {
        this.setModifiedTime(System.currentTimeMillis());
    }

    public void setModifiedTime(long time) {
        long oldTime = this.getModifiedTime();
        DOMUtils.setAttribute(this.getWorkbookElement(), "timestamp", Long.toString(time));
        long newTime = this.getModifiedTime();
        this.fireValueChange("modifyTime", oldTime, newTime);
    }

    private static interface ISaveable {
        public void run() throws IOException, CoreException;
    }
}

