/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.AbstractWorkbookBuilder;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookLoader;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WorkbookBuilderImpl
extends AbstractWorkbookBuilder
implements ErrorHandler {
    private IEncryptionHandler defaultEncryptionHandler = null;
    private DocumentBuilderFactory documentBuilderFactory = null;

    public synchronized void setDefaultEncryptionHandler(IEncryptionHandler encryptionHandler) {
        if (this.defaultEncryptionHandler != null) {
            return;
        }
        this.defaultEncryptionHandler = encryptionHandler;
    }

    private synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", Boolean.TRUE);
            factory.setNamespaceAware(true);
            this.documentBuilderFactory = factory;
        }
        return this.documentBuilderFactory;
    }

    private DocumentBuilder getDocumentCreator() {
        try {
            return this.getDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public DocumentBuilder getDocumentLoader() throws CoreException {
        try {
            DocumentBuilder loader = this.getDocumentBuilderFactory().newDocumentBuilder();
            loader.setErrorHandler(this);
            return loader;
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(12, (Throwable)e);
        }
    }

    public IWorkbook createWorkbook() {
        return this.newWorkbook(null);
    }

    public IWorkbook createWorkbook(String targetPath) {
        return this.newWorkbook(targetPath);
    }

    public IWorkbook createWorkbook(IStorage storage) {
        WorkbookImpl wb = this.newWorkbook(null);
        wb.setTempStorage(storage);
        return wb;
    }

    private WorkbookImpl newWorkbook(String file) {
        Document impl = this.createDocument();
        WorkbookImpl workbook = new WorkbookImpl(impl, file);
        return workbook;
    }

    public IWorkbook createWorkbookOnTemp(String tempLocation) {
        if (tempLocation == null) {
            throw new IllegalArgumentException("Temp location is null");
        }
        File dir = new File(tempLocation);
        if (!dir.exists()) {
            throw new IllegalArgumentException("Temp location not exists: " + tempLocation);
        }
        return this.createWorkbook(new DirectoryStorage(dir));
    }

    public Document createDocument() {
        return this.getDocumentCreator().newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IWorkbook doLoadFromSteam(InputStream in, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        File tempDir = new File(Core.getWorkspace().getTempDir("transient/" + Core.getIdFactory().createId()));
        FileUtils.ensureDirectory(tempDir);
        DirectoryStorage tempStorage = new DirectoryStorage(tempDir);
        try {
            ZipInputStream zin = new ZipInputStream(in);
            try {
                FileUtils.extractZipFile(zin, tempStorage.getOutputTarget());
            }
            finally {
                zin.close();
            }
            IWorkbook iWorkbook = this.loadFromInputSource(tempStorage.getInputSource(), storage, encryptionHandler);
            return iWorkbook;
        }
        finally {
            tempStorage.clear();
        }
    }

    public IWorkbook loadFromInputSource(IInputSource source, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (storage == null) {
            storage = new ByteArrayStorage();
        }
        if (encryptionHandler == null) {
            encryptionHandler = this.defaultEncryptionHandler;
        }
        return new WorkbookLoader(this, source, storage, encryptionHandler).load();
    }

    public void error(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception, "Error while loading workbook");
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception, "Fatal error while loading workbook");
    }

    public void warning(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception, "Warning while loading workbook");
    }
}

