/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.IBoundary;
import org.xmind.core.IImage;
import org.xmind.core.INotes;
import org.xmind.core.INumbering;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicPath;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Topic;
import org.xmind.core.internal.dom.BoundaryImpl;
import org.xmind.core.internal.dom.ImageImpl;
import org.xmind.core.internal.dom.InternalHyperlinkUtils;
import org.xmind.core.internal.dom.NotesImpl;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.NumberingImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.SummaryImpl;
import org.xmind.core.internal.dom.TopicExtensionImpl;
import org.xmind.core.internal.dom.TopicPathImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.event.NullCoreEventSupport;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.ILabelRefCounter;
import org.xmind.core.util.IMarkerRefCounter;
import org.xmind.core.util.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicImpl
extends Topic
implements ICoreEventSource {
    private Element implementation;
    private WorkbookImpl ownedWorkbook;
    private NotesImpl notes;
    private ImageImpl image;
    private NumberingImpl numbering;
    private ICoreEventSupport coreEventSupport;
    private Map<String, TopicExtensionImpl> extensions = new HashMap<String, TopicExtensionImpl>();

    public TopicImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.implementation = DOMUtils.addIdAttribute(implementation);
        this.ownedWorkbook = ownedWorkbook;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TopicImpl)) {
            return false;
        }
        TopicImpl that = (TopicImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    @Override
    public String toString() {
        return "TPC#" + this.getId() + "(" + this.getTitleText() + ")";
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Element.class || adapter == Node.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public String getId() {
        return this.implementation.getAttribute("id");
    }

    @Override
    protected String getLocalTitleText() {
        return DOMUtils.getTextContentByTag(this.implementation, "title");
    }

    @Override
    public void setTitleText(String titleText) {
        String oldValue = this.getLocalTitleText();
        DOMUtils.setText(this.implementation, "title", titleText);
        String newValue = this.getLocalTitleText();
        this.fireValueChange("titleText", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public boolean isFolded() {
        String value = DOMUtils.getAttribute(this.implementation, "branch");
        return value != null && value.contains("folded");
    }

    @Override
    public void setFolded(boolean folded) {
        Boolean oldValue = this.isFolded();
        String value = folded ? "folded" : null;
        DOMUtils.setAttribute(this.implementation, "branch", value);
        Boolean newValue = this.isFolded();
        this.fireValueChange("topicFolded", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public String getStyleId() {
        return DOMUtils.getAttribute(this.implementation, "style-id");
    }

    @Override
    public void setStyleId(String styleId) {
        String oldValue = this.getStyleId();
        WorkbookImpl workbook = this.getRealizedWorkbook();
        this.decreaseStyleRef(workbook);
        DOMUtils.setAttribute(this.implementation, "style-id", styleId);
        this.increaseStyleRef(workbook);
        String newValue = this.getStyleId();
        this.fireValueChange("style", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public boolean hasPosition() {
        Element e = DOMUtils.getFirstChildElementByTag(this.implementation, "position");
        if (e == null) {
            return false;
        }
        return e.hasAttribute("svg:x") && e.hasAttribute("svg:y");
    }

    @Override
    public Point getPosition() {
        Element e = DOMUtils.getFirstChildElementByTag(this.implementation, "position");
        if (e == null) {
            return null;
        }
        String x = DOMUtils.getAttribute(e, "svg:x");
        String y = DOMUtils.getAttribute(e, "svg:y");
        if (x == null && y == null) {
            return null;
        }
        return new Point(NumberUtils.safeParseInt(x, 0), NumberUtils.safeParseInt(y, 0));
    }

    @Override
    public void setPosition(int x, int y) {
        Point oldValue = this.getPosition();
        Element e = DOMUtils.ensureChildElement(this.implementation, "position");
        DOMUtils.setAttribute(e, "svg:x", Integer.toString(x));
        DOMUtils.setAttribute(e, "svg:y", Integer.toString(y));
        Point newValue = this.getPosition();
        this.fireValueChange("position", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    protected void removePosition() {
        Point oldValue = this.getPosition();
        Element e = DOMUtils.getFirstChildElementByTag(this.implementation, "position");
        if (e != null) {
            this.implementation.removeChild(e);
        }
        Point newValue = this.getPosition();
        this.fireValueChange("position", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public String getType() {
        if (this.isRoot()) {
            return "root";
        }
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "topics")) {
            return TopicImpl.getType((Element)p);
        }
        return null;
    }

    @Override
    public List<ITopic> getChildren(String type) {
        if (type == null) {
            return NO_CHILDREN;
        }
        Element ts = TopicImpl.findSubtopicsElement(this.implementation, type);
        if (ts != null) {
            return this.getChildren(ts);
        }
        return NO_CHILDREN;
    }

    @Override
    public boolean hasChildren(String type) {
        if (type == null) {
            return false;
        }
        Element ts = TopicImpl.findSubtopicsElement(this.implementation, type);
        if (ts != null) {
            return DOMUtils.hasChildElementByTag(ts, "topic");
        }
        return false;
    }

    protected static Element findSubtopicsElement(Element topicElement, String type) {
        Element c = DOMUtils.getFirstChildElementByTag(topicElement, "children");
        if (c != null) {
            return TopicImpl.findSubtopicsElementFromChildren(c, type);
        }
        return null;
    }

    private static Element findSubtopicsElementFromChildren(Element c, String type) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(c, "topics");
        while (it.hasNext()) {
            Element ts = it.next();
            if (!type.equals(TopicImpl.getType(ts))) continue;
            return ts;
        }
        return null;
    }

    protected static String getType(Element topicsImpl) {
        return DOMUtils.getAttribute(topicsImpl, "type");
    }

    private List<ITopic> getChildren(Element ts) {
        return DOMUtils.getChildList(ts, "topic", this.ownedWorkbook.getAdaptableRegistry());
    }

    @Override
    public Set<String> getChildrenTypes() {
        Element c = DOMUtils.getFirstChildElementByTag(this.implementation, "children");
        if (c == null) {
            return NO_TYPES;
        }
        ArrayList<String> list = new ArrayList<String>(c.getChildNodes().getLength());
        Iterator<Element> it = DOMUtils.childElementIterByTag(c, "topics");
        while (it.hasNext()) {
            Element ts = it.next();
            String type = TopicImpl.getType(ts);
            if (type == null || list.contains(type)) continue;
            list.add(type);
        }
        return DOMUtils.unmodifiableSet(list);
    }

    @Override
    public void add(ITopic child, int index, String type) {
        Element t = ((TopicImpl)child).getImplementation();
        Element c = DOMUtils.ensureChildElement(this.implementation, "children");
        Element ts = TopicImpl.findSubtopicsElementFromChildren(c, type);
        if (ts == null) {
            ts = DOMUtils.createElement(c, "topics");
            DOMUtils.setAttribute(ts, "type", type);
        }
        Node n = null;
        Element[] es = DOMUtils.getChildElementsByTag(ts, "topic");
        n = index >= 0 && index < es.length ? ts.insertBefore(t, es[index]) : ts.appendChild(t);
        if (n != null) {
            if (!this.isOrphan()) {
                ((TopicImpl)child).addNotify(this.getRealizedWorkbook(), this.getRealizedSheet(), this);
            }
            this.fireIndexedTargetChange("topicAdd", child, child.getIndex(), type);
            this.updateModifiedTime();
        }
    }

    @Override
    public void add(ITopic child, String type) {
        this.add(child, -1, type);
    }

    @Override
    public void add(ITopic child) {
        this.add(child, -1, "attached");
    }

    @Override
    public void remove(ITopic child) {
        Element t = ((TopicImpl)child).getImplementation();
        Node p = t.getParentNode();
        if (DOMUtils.isElementByTag(p, "topics")) {
            Element ts = (Element)p;
            if (DOMUtils.isElementByTag(p = p.getParentNode(), "children")) {
                Element c = (Element)p;
                if ((p = p.getParentNode()) == this.implementation) {
                    int index = child.getIndex();
                    String type = DOMUtils.getAttribute(ts, "type");
                    ((TopicImpl)child).removeNotify(this.getRealizedWorkbook(), this.getRealizedSheet(), null);
                    Node n = ts.removeChild(t);
                    if (!ts.hasChildNodes()) {
                        c.removeChild(ts);
                        if (!c.hasChildNodes()) {
                            this.implementation.removeChild(c);
                        }
                    }
                    if (n != null) {
                        this.fireIndexedTargetChange("topicRemove", child, index, type);
                        this.updateModifiedTime();
                    }
                }
            }
        }
    }

    @Override
    public ITopic getParent() {
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "topics") && DOMUtils.isElementByTag(p = p.getParentNode(), "children") && DOMUtils.isElementByTag(p = p.getParentNode(), "topic")) {
            return (ITopic)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(p);
        }
        return null;
    }

    @Override
    public boolean isRoot() {
        Node p = this.implementation.getParentNode();
        return DOMUtils.isElementByTag(p, "sheet");
    }

    @Override
    public ISheet getOwnedSheet() {
        Node s = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(s, "sheet")) {
            return (ISheet)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(s);
        }
        return super.getOwnedSheet();
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    @Override
    public ITopicPath getPath() {
        return new TopicPathImpl(this);
    }

    @Override
    public int getIndex() {
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "topics")) {
            return DOMUtils.getElementIndex(p, "topic", this.implementation);
        }
        return -1;
    }

    @Override
    public String getHyperlink() {
        return DOMUtils.getAttribute(this.implementation, "xlink:href");
    }

    @Override
    public void setHyperlink(String hyperlink) {
        String oldValue = this.getHyperlink();
        WorkbookImpl workbook = this.getRealizedWorkbook();
        InternalHyperlinkUtils.deactivateHyperlink(workbook, oldValue, this);
        DOMUtils.setAttribute(this.implementation, "xlink:href", hyperlink);
        InternalHyperlinkUtils.activateHyperlink(workbook, this.getHyperlink(), this);
        String newValue = this.getHyperlink();
        this.fireValueChange("topicHyperlink", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public INotes getNotes() {
        if (this.notes == null) {
            this.notes = new NotesImpl(this.implementation, this);
        }
        return this.notes;
    }

    public void setNotes(INotes notes) {
        if (notes != null) {
            this.notes = (NotesImpl)notes;
        }
    }

    @Override
    public INumbering getNumbering() {
        if (this.numbering == null) {
            this.numbering = new NumberingImpl(this.implementation, this);
        }
        return this.numbering;
    }

    @Override
    public void addMarker(String markerId) {
        if (markerId == null) {
            return;
        }
        Element ms = DOMUtils.ensureChildElement(this.implementation, "marker-refs");
        Element m = this.getMarkerRefElement(markerId, ms);
        if (m != null) {
            return;
        }
        m = DOMUtils.createElement(ms, "marker-ref");
        m.setAttribute("marker-id", markerId);
        WorkbookImpl workbook = this.getRealizedWorkbook();
        if (workbook != null) {
            workbook.getMarkerRefCounter().increaseRef(markerId);
        }
        this.fireTargetChange("markerRefAdd", markerId);
        SheetImpl sheet = this.getRealizedSheet();
        if (sheet != null) {
            sheet.getMarkerRefCounter().increaseRef(markerId);
        }
        this.updateModifiedTime();
    }

    @Override
    public void removeMarker(String markerId) {
        if (markerId == null) {
            return;
        }
        Element ms = this.getMarkerRefsElement();
        if (ms == null) {
            return;
        }
        Element m = this.getMarkerRefElement(markerId, ms);
        if (m == null) {
            return;
        }
        Node n = ms.removeChild(m);
        if (!ms.hasChildNodes()) {
            this.implementation.removeChild(ms);
        }
        if (n != null) {
            WorkbookImpl workbook = this.getRealizedWorkbook();
            if (workbook != null) {
                workbook.getMarkerRefCounter().decreaseRef(markerId);
            }
            this.fireTargetChange("markerRefRemove", markerId);
            SheetImpl sheet = this.getRealizedSheet();
            if (sheet != null) {
                sheet.getMarkerRefCounter().decreaseRef(markerId);
            }
            this.updateModifiedTime();
        }
    }

    @Override
    public boolean hasMarker(String markerId) {
        if (markerId == null) {
            return false;
        }
        return this.getMarkerRefElement(markerId) != null;
    }

    public IMarkerRef getMarkerRef(String markerId) {
        if (markerId == null) {
            return null;
        }
        Element m = this.getMarkerRefElement(markerId);
        if (m != null) {
            return (IMarkerRef)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(m);
        }
        return null;
    }

    @Override
    public Set<IMarkerRef> getMarkerRefs() {
        Element ms = this.getMarkerRefsElement();
        if (ms == null) {
            return NO_MARKER_REFS;
        }
        return DOMUtils.getChildSet(ms, "marker-ref", this.ownedWorkbook.getAdaptableRegistry());
    }

    private Element getMarkerRefsElement() {
        return DOMUtils.getFirstChildElementByTag(this.implementation, "marker-refs");
    }

    private Element getMarkerRefElement(String markerId) {
        Element ms = this.getMarkerRefsElement();
        if (ms == null) {
            return null;
        }
        return this.getMarkerRefElement(markerId, ms);
    }

    private Element getMarkerRefElement(String markerId, Element ms) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(ms, "marker-ref");
        while (it.hasNext()) {
            Element m = it.next();
            if (!markerId.equals(m.getAttribute("marker-id"))) continue;
            return m;
        }
        return null;
    }

    @Override
    public void addBoundary(IBoundary boundary) {
        Element b = ((BoundaryImpl)boundary).getImplementation();
        Element bs = DOMUtils.ensureChildElement(this.implementation, "boundaries");
        Node n = bs.appendChild(b);
        if (n != null) {
            if (!this.isOrphan()) {
                ((BoundaryImpl)boundary).addNotify(this.getRealizedWorkbook(), this);
            }
            this.fireTargetChange("boundaryAdd", boundary);
            this.updateModifiedTime();
        }
    }

    @Override
    public void removeBoundary(IBoundary boundary) {
        Element bs = DOMUtils.getFirstChildElementByTag(this.implementation, "boundaries");
        if (bs == null) {
            return;
        }
        Element b = ((BoundaryImpl)boundary).getImplementation();
        if (b.getParentNode() == bs) {
            ((BoundaryImpl)boundary).removeNotify(this.getRealizedWorkbook(), this);
            Node n = bs.removeChild(b);
            if (!bs.hasChildNodes()) {
                this.implementation.removeChild(bs);
            }
            if (n != null) {
                this.fireTargetChange("boundaryRemove", boundary);
                this.updateModifiedTime();
            }
        }
    }

    @Override
    public Set<IBoundary> getBoundaries() {
        Element bs = DOMUtils.getFirstChildElementByTag(this.implementation, "boundaries");
        if (bs == null) {
            return NO_BOUNDARIES;
        }
        return DOMUtils.getChildSet(bs, "boundary", this.ownedWorkbook.getAdaptableRegistry());
    }

    @Override
    public void addSummary(ISummary summary) {
        Element s = ((SummaryImpl)summary).getImplementation();
        Element ss = DOMUtils.ensureChildElement(this.implementation, "summaries");
        Node n = ss.appendChild(s);
        if (n != null) {
            if (!this.isOrphan()) {
                ((SummaryImpl)summary).addNotify(this.getRealizedWorkbook(), this);
            }
            this.fireTargetChange("summaryAdd", summary);
            this.updateModifiedTime();
        }
    }

    @Override
    public void removeSummary(ISummary summary) {
        Element ss = DOMUtils.getFirstChildElementByTag(this.implementation, "summaries");
        if (ss == null) {
            return;
        }
        Element s = ((SummaryImpl)summary).getImplementation();
        if (s.getParentNode() == ss) {
            ((SummaryImpl)summary).removeNotify(this.getRealizedWorkbook(), this);
            Node n = ss.removeChild(s);
            if (!ss.hasChildNodes()) {
                this.implementation.removeChild(ss);
            }
            if (n != null) {
                this.fireTargetChange("summaryRemove", summary);
                this.updateModifiedTime();
            }
        }
    }

    @Override
    public Set<ISummary> getSummaries() {
        Element ss = DOMUtils.getFirstChildElementByTag(this.implementation, "summaries");
        if (ss == null) {
            return NO_SUMMARIES;
        }
        return DOMUtils.getChildSet(ss, "summary", this.ownedWorkbook.getAdaptableRegistry());
    }

    @Override
    public String getStructureClass() {
        return DOMUtils.getAttribute(this.implementation, "structure-class");
    }

    @Override
    public void setStructureClass(String structureClass) {
        String oldValue = this.getStructureClass();
        DOMUtils.setAttribute(this.implementation, "structure-class", structureClass);
        String newValue = this.getStructureClass();
        this.fireValueChange("structureClass", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public Set<String> getLabels() {
        NodeList c;
        int num;
        Element ls = DOMUtils.getFirstChildElementByTag(this.implementation, "labels");
        if (ls != null && (num = (c = ls.getChildNodes()).getLength()) > 0) {
            ArrayList<String> set = new ArrayList<String>(num);
            for (int i = 0; i < num; ++i) {
                Node n = c.item(i);
                if (!DOMUtils.isElementByTag(n, "label")) continue;
                set.add(n.getTextContent());
            }
            return DOMUtils.unmodifiableSet(set);
        }
        return NO_LABELS;
    }

    private Element findLabelElement(String label, Element ls) {
        NodeList c = ls.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String text;
            Node n = c.item(i);
            if (!DOMUtils.isElementByTag(n, "label") || !label.equals(text = n.getTextContent())) continue;
            return (Element)n;
        }
        return null;
    }

    @Override
    public void addLabel(String label) {
        Element existing;
        if (label == null) {
            return;
        }
        Element ls = DOMUtils.getFirstChildElementByTag(this.implementation, "labels");
        if (ls != null && (existing = this.findLabelElement(label, ls)) != null) {
            return;
        }
        Set<String> oldValue = this.getLabels();
        this.addLabelElement(ls, label);
        Set<String> newValue = this.getLabels();
        this.fireValueChange("labels", oldValue, newValue);
        SheetImpl sheet = this.getRealizedSheet();
        if (sheet != null) {
            sheet.getLabelRefCounter().increaseRef(label);
        }
        this.updateModifiedTime();
    }

    @Override
    public void removeLabel(String label) {
        if (label == null) {
            return;
        }
        Element ls = DOMUtils.getFirstChildElementByTag(this.implementation, "labels");
        if (ls == null) {
            return;
        }
        Element l = this.findLabelElement(label, ls);
        if (l == null) {
            return;
        }
        Set<String> oldValue = this.getLabels();
        Node n = ls.removeChild(l);
        if (n != null) {
            if (!ls.hasChildNodes()) {
                this.implementation.removeChild(ls);
            }
            Set<String> newValue = this.getLabels();
            this.fireValueChange("labels", oldValue, newValue);
            SheetImpl sheet = this.getRealizedSheet();
            if (sheet != null) {
                sheet.getLabelRefCounter().decreaseRef(label);
            }
            this.updateModifiedTime();
        }
    }

    @Override
    public void setLabels(Collection<String> labels) {
        Set<String> oldValue = this.getLabels();
        Element ls = DOMUtils.getFirstChildElementByTag(this.implementation, "labels");
        if (ls != null) {
            this.implementation.removeChild(ls);
            ls = null;
        }
        if (labels != null && !labels.isEmpty()) {
            for (String label : labels) {
                if (label == null) continue;
                ls = this.addLabelElement(ls, label);
            }
        }
        Set<String> newValue = this.getLabels();
        this.fireValueChange("labels", oldValue, newValue);
        SheetImpl sheet = this.getRealizedSheet();
        if (sheet != null) {
            ILabelRefCounter counter = sheet.getLabelRefCounter();
            ArrayList<String> added = new ArrayList<String>(newValue);
            added.removeAll(oldValue);
            ArrayList<String> removed = new ArrayList<String>(oldValue);
            removed.removeAll(newValue);
            for (String increased : added) {
                counter.increaseRef(increased);
            }
            for (String decreased : removed) {
                counter.decreaseRef(decreased);
            }
        }
        this.updateModifiedTime();
    }

    @Override
    public void removeAllLabels() {
        this.setLabels(NO_LABELS);
    }

    private Element addLabelElement(Element ls, String label) {
        if (ls == null) {
            ls = DOMUtils.createElement(this.implementation, "labels");
        }
        Element l = DOMUtils.createElement(ls, "label");
        l.setTextContent(label);
        return ls;
    }

    @Override
    public IImage getImage() {
        if (this.image == null) {
            this.image = new ImageImpl(this.implementation, this);
        }
        return this.image;
    }

    @Override
    public int getTitleWidth() {
        Element t = DOMUtils.getFirstChildElementByTag(this.implementation, "title");
        return t == null ? -1 : NumberUtils.safeParseInt(DOMUtils.getAttribute(t, "svg:width"), -1);
    }

    @Override
    public void setTitleWidth(int width) {
        Element t;
        Integer oldValue = this.getTitleWidthValue();
        if (width == -1) {
            t = DOMUtils.getFirstChildElementByTag(this.implementation, "title");
            if (t != null) {
                t.removeAttribute("svg:width");
                if (!t.hasChildNodes() && !t.hasAttributes()) {
                    this.implementation.removeChild(t);
                }
            }
        } else {
            t = DOMUtils.ensureChildElement(this.implementation, "title");
            t.setAttribute("svg:width", String.valueOf(width));
        }
        Integer newValue = this.getTitleWidthValue();
        this.fireValueChange("titleWidth", oldValue, newValue);
        this.updateModifiedTime();
    }

    private Integer getTitleWidthValue() {
        int width = this.getTitleWidth();
        if (width != -1) {
            return width;
        }
        return null;
    }

    private Iterator<TopicExtensionImpl> iterExtensions() {
        return this.iterExtensions(!this.isOrphan());
    }

    private Iterator<TopicExtensionImpl> iterExtensions(final boolean realized) {
        Element es = DOMUtils.getFirstChildElementByTag(this.implementation, "extensions");
        final Iterator<Element> it = es == null ? null : DOMUtils.childElementIterByTag(es, "extension");
        return new Iterator<TopicExtensionImpl>(){
            TopicExtensionImpl next = this.findNext();

            @Override
            public void remove() {
            }

            private TopicExtensionImpl findNext() {
                if (it == null) {
                    return null;
                }
                while (it.hasNext()) {
                    Element ele = (Element)it.next();
                    String providerName = ele.getAttribute("provider");
                    if (providerName == null || "".equals(providerName)) continue;
                    TopicExtensionImpl ext = (TopicExtensionImpl)TopicImpl.this.extensions.get(providerName);
                    if (ext == null) {
                        ext = new TopicExtensionImpl(ele, TopicImpl.this);
                        TopicImpl.this.extensions.put(providerName, ext);
                        if (realized) {
                            ext.addNotify(TopicImpl.this.ownedWorkbook);
                        }
                    }
                    return ext;
                }
                return null;
            }

            @Override
            public TopicExtensionImpl next() {
                TopicExtensionImpl n = this.next;
                this.next = this.findNext();
                return n;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    @Override
    public ITopicExtension getExtension(String providerName) {
        Iterator<TopicExtensionImpl> it = this.iterExtensions();
        while (it.hasNext()) {
            TopicExtensionImpl ext = it.next();
            if (!providerName.equals(ext.getProviderName())) continue;
            return ext;
        }
        return null;
    }

    @Override
    public ITopicExtension createExtension(String providerName) {
        ITopicExtension ext = this.getExtension(providerName);
        if (ext == null) {
            Element es = DOMUtils.ensureChildElement(this.implementation, "extensions");
            Element e = DOMUtils.createElement(es, "extension");
            e.setAttribute("provider", providerName);
            ext = new TopicExtensionImpl(e, this);
            this.extensions.put(providerName, (TopicExtensionImpl)ext);
            if (!this.isOrphan()) {
                ((TopicExtensionImpl)ext).addNotify(this.ownedWorkbook);
            }
            this.updateModifiedTime();
        }
        return ext;
    }

    private Element findExtensionElement(Element es, String providerName) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(es, "extension");
        while (it.hasNext()) {
            Element e = it.next();
            if (!providerName.equals(e.getAttribute("provider"))) continue;
            return e;
        }
        return null;
    }

    @Override
    public void deleteExtension(String providerName) {
        Element e;
        Element es = DOMUtils.getFirstChildElementByTag(this.implementation, "extensions");
        if (es != null && (e = this.findExtensionElement(es, providerName)) != null) {
            es.removeChild(e);
            if (!es.hasChildNodes()) {
                this.implementation.removeChild(es);
            }
            this.updateModifiedTime();
        }
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    protected void fireValueChange(String type, Object oldValue, Object newValue) {
        ICoreEventSupport coreEventSupport = this.getCoreEventSupport();
        if (coreEventSupport != null) {
            coreEventSupport.dispatchValueChange(this, type, oldValue, newValue);
        }
    }

    protected void fireIndexedTargetChange(String type, Object target, int index, Object data) {
        ICoreEventSupport coreEventSupport = this.getCoreEventSupport();
        if (coreEventSupport != null) {
            CoreEvent event = new CoreEvent((ICoreEventSource)this, type, target, index);
            event.setData(data);
            coreEventSupport.dispatch(this, event);
        }
    }

    protected void fireTargetChange(String type, Object target) {
        ICoreEventSupport coreEventSupport = this.getCoreEventSupport();
        if (coreEventSupport != null) {
            coreEventSupport.dispatchTargetChange(this, type, target);
        }
    }

    public void setCoreEventSupport(ICoreEventSupport coreEventSupport) {
        this.coreEventSupport = coreEventSupport;
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport != null) {
            return this.coreEventSupport;
        }
        return NullCoreEventSupport.getInstance();
    }

    protected WorkbookImpl getRealizedWorkbook() {
        if (this.getPath().getWorkbook() == this.ownedWorkbook) {
            return this.ownedWorkbook;
        }
        return null;
    }

    protected SheetImpl getRealizedSheet() {
        ISheet sheet = this.getOwnedSheet();
        if (sheet != null && sheet instanceof SheetImpl) {
            return (SheetImpl)sheet;
        }
        return null;
    }

    protected void addNotify(WorkbookImpl workbook, SheetImpl sheet, TopicImpl parent) {
        this.getImplementation().setIdAttribute("id", true);
        workbook.getAdaptableRegistry().registerById(this, this.getId(), this.getImplementation().getOwnerDocument());
        this.setCoreEventSupport(parent != null ? parent.getCoreEventSupport() : sheet.getCoreEventSupport());
        this.increaseLabelRefs(sheet);
        this.increaseMarkerRefs(workbook, sheet);
        this.increaseStyleRef(workbook);
        this.activateHyperlinks(workbook);
        ((NotesImpl)this.getNotes()).addNotify(workbook);
        for (ITopic t : this.getAllChildren()) {
            ((TopicImpl)t).addNotify(workbook, sheet, this);
        }
        for (IBoundary b : this.getBoundaries()) {
            ((BoundaryImpl)b).addNotify(workbook, this);
        }
        for (ISummary s : this.getSummaries()) {
            ((SummaryImpl)s).addNotify(workbook, this);
        }
        this.extensionsAddNotify(workbook);
    }

    protected void removeNotify(WorkbookImpl workbook, SheetImpl sheet, TopicImpl parent) {
        this.extensionsRemoveNotify(workbook);
        for (ISummary s : this.getSummaries()) {
            ((SummaryImpl)s).removeNotify(workbook, this);
        }
        for (IBoundary b : this.getBoundaries()) {
            ((BoundaryImpl)b).removeNotify(workbook, this);
        }
        for (ITopic t : this.getAllChildren()) {
            ((TopicImpl)t).removeNotify(workbook, sheet, this);
        }
        ((NotesImpl)this.getNotes()).removeNotify(workbook);
        this.deactivateHyperlinks(workbook);
        this.decreaseStyleRef(workbook);
        this.decreaseMarkerRefs(workbook, sheet);
        this.decreaseLabelRefs(sheet);
        this.setCoreEventSupport(null);
        workbook.getAdaptableRegistry().unregisterById(this, this.getId(), this.getImplementation().getOwnerDocument());
        this.getImplementation().setIdAttribute("id", false);
    }

    private void extensionsAddNotify(WorkbookImpl workbook) {
        Iterator<TopicExtensionImpl> it = this.iterExtensions(false);
        while (it.hasNext()) {
            it.next().addNotify(workbook);
        }
    }

    private void extensionsRemoveNotify(WorkbookImpl workbook) {
        Iterator<TopicExtensionImpl> it = this.iterExtensions(true);
        while (it.hasNext()) {
            it.next().removeNotify(workbook);
        }
    }

    protected void increaseStyleRef(WorkbookImpl workbook) {
        if (workbook == null) {
            return;
        }
        String styleId = this.getStyleId();
        if (styleId != null) {
            workbook.getStyleRefCounter().increaseRef(styleId);
        }
    }

    protected void decreaseStyleRef(WorkbookImpl workbook) {
        if (workbook == null) {
            return;
        }
        String styleId = this.getStyleId();
        if (styleId != null) {
            workbook.getStyleRefCounter().decreaseRef(styleId);
        }
    }

    protected void increaseMarkerRefs(WorkbookImpl workbook, SheetImpl sheet) {
        IMarkerRefCounter counter;
        IMarkerRefCounter iMarkerRefCounter = counter = sheet == null ? null : sheet.getMarkerRefCounter();
        if (workbook == null && counter == null) {
            return;
        }
        Element mrs = this.getMarkerRefsElement();
        if (mrs == null) {
            return;
        }
        Iterator<Element> it = DOMUtils.childElementIterByTag(mrs, "marker-ref");
        while (it.hasNext()) {
            String markerId = DOMUtils.getAttribute(it.next(), "marker-id");
            if (markerId == null) continue;
            if (workbook != null) {
                workbook.getMarkerRefCounter().increaseRef(markerId);
            }
            if (counter == null) continue;
            counter.increaseRef(markerId);
        }
    }

    protected void decreaseMarkerRefs(WorkbookImpl workbook, SheetImpl sheet) {
        IMarkerRefCounter counter;
        IMarkerRefCounter iMarkerRefCounter = counter = sheet == null ? null : sheet.getMarkerRefCounter();
        if (workbook == null && counter == null) {
            return;
        }
        Element mrs = this.getMarkerRefsElement();
        if (mrs == null) {
            return;
        }
        Iterator<Element> it = DOMUtils.childElementIterByTag(mrs, "marker-ref");
        while (it.hasNext()) {
            String markerId = DOMUtils.getAttribute(it.next(), "marker-id");
            if (markerId == null) continue;
            if (workbook != null) {
                workbook.getMarkerRefCounter().decreaseRef(markerId);
            }
            if (counter == null) continue;
            counter.decreaseRef(markerId);
        }
    }

    private void increaseLabelRefs(SheetImpl sheet) {
        if (sheet == null) {
            return;
        }
        Element ls = DOMUtils.getFirstChildElementByTag(this.implementation, "labels");
        if (ls == null) {
            return;
        }
        ILabelRefCounter counter = sheet.getLabelRefCounter();
        Iterator<Element> it = DOMUtils.childElementIterByTag(ls, "label");
        while (it.hasNext()) {
            String label = it.next().getTextContent();
            counter.increaseRef(label);
        }
    }

    private void decreaseLabelRefs(SheetImpl sheet) {
        if (sheet == null) {
            return;
        }
        Element ls = DOMUtils.getFirstChildElementByTag(this.implementation, "labels");
        if (ls == null) {
            return;
        }
        ILabelRefCounter counter = sheet.getLabelRefCounter();
        Iterator<Element> it = DOMUtils.childElementIterByTag(ls, "label");
        while (it.hasNext()) {
            String label = it.next().getTextContent();
            counter.decreaseRef(label);
        }
    }

    protected void activateHyperlinks(WorkbookImpl workbook) {
        InternalHyperlinkUtils.activateHyperlink(workbook, this.getHyperlink(), this);
        ((ImageImpl)this.getImage()).activateHyperlink(workbook);
    }

    protected void deactivateHyperlinks(WorkbookImpl workbook) {
        ((ImageImpl)this.getImage()).deactivateHyperlink(workbook);
        InternalHyperlinkUtils.deactivateHyperlink(workbook, this.getHyperlink(), this);
    }

    @Override
    public long getModifiedTime() {
        String time = DOMUtils.getAttribute(this.implementation, "timestamp");
        return NumberUtils.safeParseLong(time, 0L);
    }

    public void updateModifiedTime() {
        this.setModifiedTime(System.currentTimeMillis());
        ISheet sheet = this.getOwnedSheet();
        if (sheet != null) {
            ((SheetImpl)sheet).updateModifiedTime();
        }
    }

    public void setModifiedTime(long time) {
        long oldTime = this.getModifiedTime();
        DOMUtils.setAttribute(this.implementation, "timestamp", Long.toString(time));
        long newTime = this.getModifiedTime();
        this.fireValueChange("modifyTime", oldTime, newTime);
    }
}

