/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IFileEntry;
import org.xmind.core.IResourceRef;
import org.xmind.core.internal.dom.InternalHyperlinkUtils;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.marker.IMarker;
import org.xmind.core.style.IStyle;
import org.xmind.core.util.DOMUtils;

public class ResourceRefImpl
implements IResourceRef {
    private Element implementation;
    private WorkbookImpl ownedWorkbook;

    public ResourceRefImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.implementation = implementation;
        this.ownedWorkbook = ownedWorkbook;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public WorkbookImpl getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ResourceRefImpl)) {
            return false;
        }
        ResourceRefImpl that = (ResourceRefImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "ResRef#" + this.getResourceId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.implementation;
        }
        return null;
    }

    public Object getResource() {
        String type = this.getType();
        if ("file-entry".equals(type)) {
            return this.getFileEntry();
        }
        return null;
    }

    protected void addNotify(WorkbookImpl workbook) {
        String type;
        if (workbook != null && "file-entry".equals(type = this.getType())) {
            InternalHyperlinkUtils.increaseFileEntryRef(workbook, this.getResourceId());
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        String type;
        if (workbook != null && "file-entry".equals(type = this.getType())) {
            InternalHyperlinkUtils.decreaseFileEntryRef(workbook, this.getResourceId());
        }
    }

    protected IFileEntry getFileEntry() {
        String entryPath = this.getResourceId();
        return this.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
    }

    protected IMarker getMarker() {
        String markerId = this.getResourceId();
        return this.getOwnedWorkbook().getMarkerSheet().findMarker(markerId);
    }

    protected IStyle getStyle() {
        String styleId = this.getResourceId();
        return this.getOwnedWorkbook().getStyleSheet().findStyle(styleId);
    }

    public String getResourceId() {
        return DOMUtils.getAttribute(this.implementation, "resource-id");
    }

    public String getType() {
        return DOMUtils.getAttribute(this.implementation, "type");
    }
}

