/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.MarkerRef;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.marker.IMarker;
import org.xmind.core.util.DOMUtils;

public class MarkerRefImpl
extends MarkerRef {
    private Element implementation;
    private WorkbookImpl ownedWorkbook;

    public MarkerRefImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.implementation = implementation;
        this.ownedWorkbook = ownedWorkbook;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MarkerRefImpl)) {
            return false;
        }
        MarkerRefImpl that = (MarkerRefImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "MKRRef#" + this.getMarkerId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    public IMarker getMarker() {
        return this.ownedWorkbook.getMarkerSheet().findMarker(this.getMarkerId());
    }

    public String getMarkerId() {
        return DOMUtils.getAttribute(this.implementation, "marker-id");
    }

    public void setMarkerId(String markerId) {
        DOMUtils.setAttribute(this.implementation, "marker-id", markerId);
    }

    public ITopic getParent() {
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "marker-refs") && DOMUtils.isElementByTag(p = p.getParentNode(), "topic")) {
            return (ITopic)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(p);
        }
        return null;
    }

    public ISheet getOwnedSheet() {
        ITopic parent = this.getParent();
        if (parent != null) {
            return parent.getOwnedSheet();
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }
}

