/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.ControlPoint;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.RelationshipImpl;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.Point;

public class ControlPointImpl
extends ControlPoint
implements ICoreEventSource {
    private RelationshipImpl parent;
    private int index;

    public ControlPointImpl(RelationshipImpl parent, int index) {
        this.parent = parent;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public IRelationship getParent() {
        return this.parent;
    }

    public ISheet getOwnedSheet() {
        return this.parent.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.parent.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.parent.isOrphan();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ControlPointImpl)) {
            return false;
        }
        ControlPointImpl that = (ControlPointImpl)obj;
        return this.index == that.index && this.parent.equals(that.parent);
    }

    public String toString() {
        return "CP{" + this.index + "," + this.parent.toString() + "}";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.getImplementation();
        }
        if (adapter == IRelationship.class) {
            return this.parent;
        }
        return super.getAdapter(adapter);
    }

    private Element getImplementation() {
        Element cp;
        Element cps = DOMUtils.getFirstChildElementByTag(this.getRelElement(), "control-points");
        if (cps != null && (cp = this.findImplementation(cps)) != null) {
            return cp;
        }
        return null;
    }

    private Element findImplementation(Element cps) {
        Iterator<Element> cpIt = DOMUtils.childElementIterByTag(cps, "control-point");
        String indexString = String.valueOf(this.index);
        while (cpIt.hasNext()) {
            Element cp = cpIt.next();
            if (!indexString.equals(cp.getAttribute("index"))) continue;
            return cp;
        }
        return null;
    }

    private Element getRelElement() {
        return this.parent.getImplementation();
    }

    public double getPolarAmount() {
        Element ele = this.getImplementation();
        if (ele != null) {
            return NumberUtils.safeParseDouble(DOMUtils.getAttribute(ele, "amount"), 0.3);
        }
        return 0.3;
    }

    public double getPolarAngle() {
        Element ele = this.getImplementation();
        if (ele != null) {
            return NumberUtils.safeParseDouble(DOMUtils.getAttribute(ele, "angle"), 0.0);
        }
        return 0.0;
    }

    public boolean usesPolarPosition() {
        return false;
    }

    public boolean hasPolarAmount() {
        Element ele = this.getImplementation();
        if (ele != null) {
            return ele.hasAttribute("amount");
        }
        return false;
    }

    public boolean hasPolarAngle() {
        Element ele = this.getImplementation();
        if (ele != null) {
            return ele.hasAttribute("angle");
        }
        return false;
    }

    public void resetPolarAmount() {
        this.removeAttribute("amount");
    }

    public void resetPolarAngle() {
        this.removeAttribute("angle");
    }

    private void removeAttribute(String attrName) {
        Element ele = this.getImplementation();
        if (ele != null) {
            ele.removeAttribute(attrName);
            if (!ele.hasAttributes() && !ele.hasChildNodes()) {
                ele.getParentNode().removeChild(ele);
            }
        }
    }

    private Element ensureImplementation() {
        Element cps = DOMUtils.ensureChildElement(this.getRelElement(), "control-points");
        Element cp = this.findImplementation(cps);
        if (cp == null) {
            cp = DOMUtils.createElement(cps, "control-point");
            cp.setAttribute("index", String.valueOf(this.index));
        }
        return cp;
    }

    public void setPolarAmount(double amount) {
        Element ele = this.ensureImplementation();
        DOMUtils.setAttribute(ele, "amount", String.valueOf(amount));
    }

    public void setPolarAngle(double angle) {
        Element ele = this.ensureImplementation();
        DOMUtils.setAttribute(ele, "angle", String.valueOf(angle));
    }

    public Point getPosition() {
        Element implementation = this.getImplementation();
        if (implementation == null) {
            return null;
        }
        Element e = DOMUtils.getFirstChildElementByTag(implementation, "position");
        if (e == null) {
            return null;
        }
        String x = DOMUtils.getAttribute(e, "svg:x");
        String y = DOMUtils.getAttribute(e, "svg:y");
        if (x == null && y == null) {
            return null;
        }
        return new Point(NumberUtils.safeParseInt(x, 0), NumberUtils.safeParseInt(y, 0));
    }

    public boolean hasPosition() {
        Element implementation = this.getImplementation();
        if (implementation == null) {
            return false;
        }
        Element e = DOMUtils.getFirstChildElementByTag(implementation, "position");
        if (e == null) {
            return false;
        }
        return e.hasAttribute("svg:x") && e.hasAttribute("svg:y");
    }

    public void setPosition(int x, int y) {
        Element implementation = this.ensureImplementation();
        Point oldValue = this.getPosition();
        Element e = DOMUtils.ensureChildElement(implementation, "position");
        DOMUtils.setAttribute(e, "svg:x", Integer.toString(x));
        DOMUtils.setAttribute(e, "svg:y", Integer.toString(y));
        Point newValue = this.getPosition();
        this.fireValueChange("position", oldValue, newValue);
    }

    protected void removePosition() {
        Element implementation = this.getImplementation();
        if (implementation == null) {
            return;
        }
        Point oldValue = this.getPosition();
        Element e = DOMUtils.getFirstChildElementByTag(implementation, "position");
        if (e != null) {
            implementation.removeChild(e);
        }
        Point newValue = this.getPosition();
        this.fireValueChange("position", oldValue, newValue);
    }

    public void setPosition(Point position) {
        if (position == null) {
            this.removePosition();
        } else {
            this.setPosition(position.x, position.y);
        }
    }

    protected void fireValueChange(String type, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, type, oldValue, newValue);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.parent.getCoreEventSupport();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }
}

