/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.core.ICloneData;
import org.xmind.core.internal.ICloneDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneData
implements ICloneData {
    private Collection<Object> sources;
    private ICloneData parent;
    private Map<Object, Object> clonedElements = new HashMap<Object, Object>();
    private Map<Object, List<ICloneDataListener>> listeners = new HashMap<Object, List<ICloneDataListener>>();
    private Map<Object, Object> caches = new HashMap<Object, Object>();

    public CloneData(Collection<? extends Object> sources, ICloneData parent) {
        this.sources = new ArrayList<Object>(sources);
        this.parent = parent;
    }

    @Override
    public String getString(String category, String source) {
        return (String)this.get(new CategorizedString(category, source));
    }

    @Override
    public void putString(String category, String source, String cloned) {
        CategorizedString sourceObj = new CategorizedString(category, source);
        this.doPut(sourceObj, cloned);
        this.fireStringCloned(sourceObj, category, source, cloned);
    }

    @Override
    public Object get(Object source) {
        Object cloned;
        Object object = cloned = this.clonedElements.isEmpty() ? null : this.clonedElements.get(source);
        if (cloned == null && this.parent != null) {
            cloned = this.parent.get(source);
        }
        return cloned;
    }

    @Override
    public boolean hasCloned() {
        if (!this.clonedElements.isEmpty()) {
            for (Object cloned : this.clonedElements.values()) {
                if (cloned == null) continue;
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.hasCloned();
        }
        return false;
    }

    @Override
    public Collection<Object> getCloneds() {
        ArrayList<Object> list = new ArrayList<Object>(this.sources.size());
        for (Object source : this.sources) {
            Object cloned = this.get(source);
            if (cloned == null) continue;
            list.add(cloned);
        }
        return list;
    }

    @Override
    public Collection<Object> getSources() {
        return this.sources;
    }

    public ICloneData getParent() {
        return this.parent;
    }

    @Override
    public void put(Object source, Object cloned) {
        this.doPut(source, cloned);
        this.fireObjectCloned(source, cloned);
    }

    protected void doPut(Object source, Object cloned) {
        this.clonedElements.put(source, cloned);
        if (this.parent != null) {
            this.parent.put(source, cloned);
        }
    }

    public void cache(Object key, Object value) {
        this.caches.put(key, value);
    }

    public Object getCache(Object key) {
        return this.caches.isEmpty() ? null : this.caches.get(key);
    }

    private void fireObjectCloned(Object source, Object cloned) {
        if (this.listeners.isEmpty()) {
            return;
        }
        List<ICloneDataListener> list = this.listeners.get(source);
        if (list == null || list.isEmpty()) {
            this.listeners.remove(source);
            return;
        }
        for (Object o : list.toArray()) {
            ((ICloneDataListener)o).objectCloned(source, cloned);
        }
    }

    private void fireStringCloned(Object sourceObj, String category, String source, String cloned) {
        if (this.listeners.isEmpty()) {
            return;
        }
        List<ICloneDataListener> list = this.listeners.get(sourceObj);
        if (list == null || list.isEmpty()) {
            this.listeners.remove(sourceObj);
            return;
        }
        for (Object o : list.toArray()) {
            ((ICloneDataListener)o).stringCloned(category, source, cloned);
        }
    }

    public void addCloneDataListener(Object source, ICloneDataListener listener) {
        List<ICloneDataListener> list = this.listeners.get(source);
        if (list == null) {
            list = new ArrayList<ICloneDataListener>();
            this.listeners.put(source, list);
        }
        list.add(listener);
    }

    public void removeCloneDataListener(Object source, ICloneDataListener listener) {
        if (this.listeners.isEmpty()) {
            return;
        }
        List<ICloneDataListener> list = this.listeners.get(source);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.listeners.remove(source);
        }
    }

    public void addCloneDataListener(String category, String source, ICloneDataListener listener) {
        this.addCloneDataListener(new CategorizedString(category, source), listener);
    }

    public void removeCloneDataListener(String category, String source, ICloneDataListener listener) {
        this.removeCloneDataListener(new CategorizedString(category, source), listener);
    }

    @Override
    public boolean isCloned(Object source) {
        if (this.clonedElements != null && this.clonedElements.containsKey(source)) {
            return true;
        }
        return this.parent != null && this.parent.isCloned(source);
    }

    @Override
    public boolean isCloned(String category, String source) {
        return this.isCloned(new CategorizedString(category, source));
    }

    private static class CategorizedString {
        private String category;
        private String source;

        public CategorizedString(String category, String source) {
            this.category = category;
            this.source = source;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof CategorizedString)) {
                return false;
            }
            CategorizedString that = (CategorizedString)obj;
            return this.category.equals(that.category) && this.source.equals(that.source);
        }

        public int hashCode() {
            return this.category.hashCode() ^ this.source.hashCode();
        }
    }
}

