/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.INotes;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookBuilder;
import org.xmind.core.io.ByteArrayStorage;

public class TestRun {
    public static void main(String[] args) throws IOException, CoreException {
        String workbookString = "parse.xmind";
        IWorkbookBuilder builder = Core.getWorkbookBuilder();
        ByteArrayStorage ist = new ByteArrayStorage();
        IEncryptionHandler iench = new IEncryptionHandler(){

            public String retrievePassword() throws CoreException {
                return "privet";
            }
        };
        IWorkbook workbook = builder.loadFromPath(workbookString, ist, iench);
        for (ISheet isheet : workbook.getSheets()) {
            System.out.println(isheet.getId());
            ITopic root = isheet.getRootTopic();
            TestRun.iterateOverTopic(root, "", "src\\test\\resources");
        }
    }

    public static void iterateOverTopic(ITopic itop, String offset, String folderBase) throws IOException {
        INotes nt;
        System.out.println(offset + itop.getTitleText());
        boolean folderCreated = new File(folderBase).mkdirs();
        for (ITopic child : itop.getAllChildren()) {
            TestRun.iterateOverTopic(child, offset + " ", folderBase + "\\" + itop.getTitleText());
        }
        if (itop.getNotes() != null && !(nt = itop.getNotes()).toString().equals("null")) {
            IPlainNotesContent plainContent = (IPlainNotesContent)nt.getContent("plain");
            System.out.println("\r\n\r\nScenario: " + itop.getTitleText() + "\r\n\r\n" + plainContent.getTextContent() + "\r\n\r\n");
            File newStoryCreated = new File(folderBase + "\\" + itop.getTitleText() + ".story");
            BufferedWriter writer = new BufferedWriter(new FileWriter(newStoryCreated));
            writer.write(plainContent.getTextContent());
            writer.close();
        }
    }
}

