/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerBeanMapper;
import org.dozer.DozerEventListener;
import org.dozer.DozerInitializer;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.dozer.builder.DestBeanBuilderCreator;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.MappingFileData;
import org.dozer.classmap.generator.BeanMappingGenerator;
import org.dozer.config.BeanContainer;
import org.dozer.config.GlobalSettings;
import org.dozer.factory.DestBeanCreator;
import org.dozer.loader.CustomMappingsLoader;
import org.dozer.loader.MappingsParser;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.xml.MappingStreamReader;
import org.dozer.loader.xml.XMLParser;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.osgi.Activator;
import org.dozer.osgi.OSGiClassLoader;
import org.dozer.propertydescriptor.PropertyDescriptorFactory;
import org.dozer.stats.StatisticsManagerImpl;
import org.dozer.util.DefaultClassLoader;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.RuntimeUtils;

public final class DozerBeanMapperBuilder {
    private List<String> mappingFiles = new ArrayList<String>(1);
    private DozerClassLoader classLoader;
    private List<CustomConverter> customConverters = new ArrayList<CustomConverter>(0);
    private List<Supplier<InputStream>> xmlMappingSuppliers = new ArrayList<Supplier<InputStream>>(0);
    private List<BeanMappingBuilder> mappingBuilders = new ArrayList<BeanMappingBuilder>(0);
    private List<DozerEventListener> eventListeners = new ArrayList<DozerEventListener>(0);
    private CustomFieldMapper customFieldMapper;
    private Map<String, CustomConverter> customConvertersWithId = new HashMap<String, CustomConverter>(0);
    private Map<String, BeanFactory> beanFactories = new HashMap<String, BeanFactory>(0);

    private DozerBeanMapperBuilder() {
    }

    public static DozerBeanMapperBuilder create() {
        return new DozerBeanMapperBuilder();
    }

    public static Mapper buildDefault() {
        DozerBeanMapperBuilder builder = DozerBeanMapperBuilder.create();
        DozerClassLoader classLoader = builder.getClassLoader();
        URL defaultMappingFile = classLoader.loadResource("dozerBeanMapping.xml");
        if (defaultMappingFile != null) {
            builder.withMappingFiles("dozerBeanMapping.xml");
        }
        return builder.withClassLoader(classLoader).build();
    }

    public DozerBeanMapperBuilder withMappingFiles(String ... mappingFiles) {
        this.mappingFiles.addAll(Arrays.asList(mappingFiles));
        return this;
    }

    public DozerBeanMapperBuilder withClassLoader(DozerClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public DozerBeanMapperBuilder withClassLoader(ClassLoader classLoader) {
        this.classLoader = new DefaultClassLoader(classLoader);
        return this;
    }

    public DozerBeanMapperBuilder withCustomConverter(CustomConverter customConverter) {
        this.customConverters.add(customConverter);
        return this;
    }

    public DozerBeanMapperBuilder withXmlMapping(Supplier<InputStream> xmlMappingSupplier) {
        this.xmlMappingSuppliers.add(xmlMappingSupplier);
        return this;
    }

    public DozerBeanMapperBuilder withMappingBuilder(BeanMappingBuilder mappingBuilder) {
        this.mappingBuilders.add(mappingBuilder);
        return this;
    }

    public DozerBeanMapperBuilder withEventListener(DozerEventListener eventListener) {
        this.eventListeners.add(eventListener);
        return this;
    }

    public DozerBeanMapperBuilder withCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.customFieldMapper = customFieldMapper;
        return this;
    }

    public DozerBeanMapperBuilder withCustomConverterWithId(String converterId, CustomConverter converter) {
        this.customConvertersWithId.put(converterId, converter);
        return this;
    }

    public DozerBeanMapperBuilder withBeanFactory(String factoryName, BeanFactory beanFactory) {
        this.beanFactories.put(factoryName, beanFactory);
        return this;
    }

    public Mapper build() {
        DozerClassLoader classLoader = this.getClassLoader();
        GlobalSettings globalSettings = new GlobalSettings(classLoader);
        BeanContainer beanContainer = new BeanContainer();
        DestBeanCreator destBeanCreator = new DestBeanCreator(beanContainer);
        destBeanCreator.setStoredFactories(this.beanFactories);
        PropertyDescriptorFactory propertyDescriptorFactory = new PropertyDescriptorFactory();
        BeanMappingGenerator beanMappingGenerator = new BeanMappingGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory);
        ClassMapBuilder classMapBuilder = new ClassMapBuilder(beanContainer, destBeanCreator, beanMappingGenerator, propertyDescriptorFactory);
        CustomMappingsLoader customMappingsLoader = new CustomMappingsLoader(new MappingsParser(beanContainer, destBeanCreator, propertyDescriptorFactory), classMapBuilder, beanContainer);
        XMLParserFactory xmlParserFactory = new XMLParserFactory(beanContainer);
        StatisticsManagerImpl statisticsManager = new StatisticsManagerImpl(globalSettings);
        DozerInitializer dozerInitializer = new DozerInitializer();
        XMLParser xmlParser = new XMLParser(beanContainer, destBeanCreator, propertyDescriptorFactory);
        DestBeanBuilderCreator destBeanBuilderCreator = new DestBeanBuilderCreator();
        ArrayList<MappingFileData> mappingsFileData = new ArrayList<MappingFileData>();
        mappingsFileData.addAll(this.readXmlMappings(xmlParserFactory, xmlParser));
        mappingsFileData.addAll(this.createMappingsWithBuilders(beanContainer, destBeanCreator, propertyDescriptorFactory));
        return new DozerBeanMapper(this.mappingFiles, globalSettings, customMappingsLoader, xmlParserFactory, statisticsManager, dozerInitializer, beanContainer, xmlParser, destBeanCreator, destBeanBuilderCreator, beanMappingGenerator, propertyDescriptorFactory, this.customConverters, mappingsFileData, this.eventListeners, this.customFieldMapper, this.customConvertersWithId);
    }

    private List<MappingFileData> createMappingsWithBuilders(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        return this.mappingBuilders.stream().map(fluentBuilder -> fluentBuilder.build(beanContainer, destBeanCreator, propertyDescriptorFactory)).collect(Collectors.toList());
    }

    private List<MappingFileData> readXmlMappings(XMLParserFactory xmlParserFactory, XMLParser xmlParser) {
        return this.xmlMappingSuppliers.stream().map(xmlMappingSupplier -> {
            try (InputStream xmlMappingStream = (InputStream)xmlMappingSupplier.get();){
                MappingStreamReader fileReader = new MappingStreamReader(xmlParserFactory, xmlParser);
                MappingFileData mappingFileData = fileReader.read(xmlMappingStream);
                return mappingFileData;
            }
            catch (IOException e) {
                throw new MappingException(e);
            }
        }).collect(Collectors.toList());
    }

    private DozerClassLoader getClassLoader() {
        if (this.classLoader == null) {
            if (RuntimeUtils.isOSGi()) {
                return new OSGiClassLoader(Activator.getBundle().getBundleContext());
            }
            return new DefaultClassLoader(DozerBeanMapperBuilder.class.getClassLoader());
        }
        return this.classLoader;
    }
}

