/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.auth;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.SchemePortResolver;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.auth.AuthCache;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.auth.AuthScheme;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.impl.StateHolder;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpHost;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.net.NamedEndpoint;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.LangUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicAuthCache
implements AuthCache {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthCache.class);
    private final Map<Key, AuthData> map = new ConcurrentHashMap<Key, AuthData>();
    private final SchemePortResolver schemePortResolver;

    public BasicAuthCache(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public BasicAuthCache() {
        this(null);
    }

    private Key key(String scheme, NamedEndpoint authority, String pathPrefix) {
        return new Key(scheme, authority.getHostName(), this.schemePortResolver.resolve(scheme, authority), pathPrefix);
    }

    private AuthData data(AuthScheme authScheme) {
        return new AuthData(authScheme.getClass(), ((StateHolder)((Object)authScheme)).store());
    }

    @Override
    public void put(HttpHost host, AuthScheme authScheme) {
        this.put(host, null, authScheme);
    }

    @Override
    public AuthScheme get(HttpHost host) {
        return this.get(host, null);
    }

    @Override
    public void remove(HttpHost host) {
        this.remove(host, null);
    }

    @Override
    public void put(HttpHost host, String pathPrefix, AuthScheme authScheme) {
        Args.notNull(host, "HTTP host");
        if (authScheme == null) {
            return;
        }
        if (authScheme instanceof StateHolder) {
            this.map.put(this.key(host.getSchemeName(), host, pathPrefix), this.data(authScheme));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Auth scheme {} cannot be cached", authScheme.getClass());
        }
    }

    @Override
    public AuthScheme get(HttpHost host, String pathPrefix) {
        block3: {
            Args.notNull(host, "HTTP host");
            AuthData authData = this.map.get(this.key(host.getSchemeName(), host, pathPrefix));
            if (authData != null) {
                try {
                    AuthScheme authScheme = authData.clazz.newInstance();
                    ((StateHolder)((Object)authScheme)).restore(authData.state);
                    return authScheme;
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("Unexpected error while reading auth scheme state", (Throwable)ex);
                }
            }
        }
        return null;
    }

    @Override
    public void remove(HttpHost host, String pathPrefix) {
        Args.notNull(host, "HTTP host");
        this.map.remove(this.key(host.getSchemeName(), host, pathPrefix));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    static class AuthData {
        final Class<? extends AuthScheme> clazz;
        final Object state;

        public AuthData(Class<? extends AuthScheme> clazz, Object state) {
            this.clazz = clazz;
            this.state = state;
        }
    }

    static class Key {
        final String scheme;
        final String host;
        final int port;
        final String pathPrefix;

        Key(String scheme, String host, int port, String pathPrefix) {
            Args.notBlank(scheme, "Scheme");
            Args.notBlank(host, "Scheme");
            this.scheme = scheme.toLowerCase(Locale.ROOT);
            this.host = host.toLowerCase(Locale.ROOT);
            this.port = port;
            this.pathPrefix = pathPrefix;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key that = (Key)obj;
                return this.scheme.equals(that.scheme) && this.host.equals(that.host) && this.port == that.port && Objects.equals(this.pathPrefix, that.pathPrefix);
            }
            return false;
        }

        public int hashCode() {
            int hash = 17;
            hash = LangUtils.hashCode(hash, this.scheme);
            hash = LangUtils.hashCode(hash, this.host);
            hash = LangUtils.hashCode(hash, this.port);
            hash = LangUtils.hashCode(hash, this.pathPrefix);
            return hash;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.scheme).append("://").append(this.host);
            if (this.port >= 0) {
                buf.append(":").append(this.port);
            }
            if (this.pathPrefix != null) {
                if (!this.pathPrefix.startsWith("/")) {
                    buf.append("/");
                }
                buf.append(this.pathPrefix);
            }
            return buf.toString();
        }
    }
}

