/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.xjar.XEntryFilter;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public abstract class XAntEntryFilter
implements XEntryFilter<JarArchiveEntry> {
    private static final String[] SYMBOLS = new String[]{"\\", "$", "(", ")", "+", ".", "[", "]", "^", "{", "}", "|"};
    private final Pattern pattern;

    protected XAntEntryFilter(String ant) {
        String regex = ant;
        for (String symbol : SYMBOLS) {
            regex = regex.replace(symbol, '\\' + symbol);
        }
        regex = regex.replace("?", ".{1}");
        regex = regex.replace("**/", "(.{0,}?/){0,}?");
        regex = regex.replace("**", ".{0,}?");
        regex = regex.replace("*", "[^/]{0,}?");
        while (regex.startsWith("/")) {
            regex = regex.substring(1);
        }
        while (regex.endsWith("/")) {
            regex = regex.substring(0, regex.length() - 1);
        }
        this.pattern = Pattern.compile(regex);
    }

    protected boolean matches(String text) {
        return this.pattern.matcher(text).matches();
    }
}

