/*
 * Decompiled with CFR 0.152.
 */
package com.github.biyanwen.comment.bean;

import cn.hutool.core.util.ReflectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class CommentIntegrator
implements Integrator {
    public static final CommentIntegrator INSTANCE = new CommentIntegrator();

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.processComment(metadata);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
    }

    protected void processComment(Metadata metadata) {
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            Property identifierProperty;
            Class clz = persistentClass.getMappedClass();
            if (clz.isAnnotationPresent(ApiModel.class)) {
                ApiModel apiModel = clz.getAnnotation(ApiModel.class);
                persistentClass.getTable().setComment(apiModel.description());
            }
            if ((identifierProperty = persistentClass.getIdentifierProperty()) != null) {
                this.propertyComment(persistentClass, identifierProperty.getName());
            } else {
                Component component = persistentClass.getIdentifierMapper();
                if (component != null) {
                    Iterator iterator = component.getPropertyIterator();
                    while (iterator.hasNext()) {
                        this.propertyComment(persistentClass, ((Property)iterator.next()).getName());
                    }
                }
            }
            Iterator iterator = persistentClass.getPropertyIterator();
            while (iterator.hasNext()) {
                this.propertyComment(persistentClass, ((Property)iterator.next()).getName());
            }
        }
    }

    private void propertyComment(PersistentClass persistentClass, String columnName) {
        try {
            String comment = this.getPropertyComment(persistentClass, columnName);
            String sqlColumnName = ((Selectable)persistentClass.getProperty(columnName).getValue().getColumnIterator().next()).getText();
            Iterator columnIterator = persistentClass.getTable().getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                if (!sqlColumnName.equalsIgnoreCase(column.getName())) continue;
                column.setComment(comment);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getPropertyComment(PersistentClass persistentClass, String columnName) throws Exception {
        String comment = null;
        Field field = ReflectUtil.getField(persistentClass.getMappedClass(), columnName);
        if (field.isAnnotationPresent(ApiModelProperty.class)) {
            comment = field.getAnnotation(ApiModelProperty.class).value();
        } else {
            PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), persistentClass.getMappedClass());
            Method readMethod = descriptor.getReadMethod();
            ApiModelProperty apiModelProperty = readMethod.getAnnotation(ApiModelProperty.class);
            if (apiModelProperty != null) {
                comment = apiModelProperty.value();
            }
        }
        return comment;
    }
}

