/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanDescCache;
import cn.hutool.core.bean.BeanException;
import cn.hutool.core.bean.BeanInfoCache;
import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.bean.DynaBean;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.bean.copier.BeanCopier;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class BeanUtil {
    public static boolean isReadableBean(Class<?> clazz) {
        return BeanUtil.hasGetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean isBean(Class<?> clazz) {
        return BeanUtil.hasSetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!ModifierUtil.isPublic(field) || ModifierUtil.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static DynaBean createDynaBean(Object bean2) {
        return new DynaBean(bean2);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return BeanDescCache.INSTANCE.getBeanDesc(clazz, () -> new BeanDesc(clazz));
    }

    public static void descForEach(Class<?> clazz, Consumer<? super PropDesc> action) {
        BeanUtil.getBeanDesc(clazz).getProps().forEach(action);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
        return ArrayUtil.filter(beanInfo.getPropertyDescriptors(), t -> false == "class".equals(t.getName()));
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        return BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase, () -> BeanUtil.internalGetPropertyDescriptorMap(clazz, ignoreCase));
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws BeanException {
        return BeanUtil.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> map = BeanUtil.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static Object getFieldValue(Object bean2, String fieldNameOrIndex) {
        if (null == bean2 || null == fieldNameOrIndex) {
            return null;
        }
        if (bean2 instanceof Map) {
            return ((Map)bean2).get(fieldNameOrIndex);
        }
        if (bean2 instanceof Collection) {
            try {
                return CollUtil.get((Collection)bean2, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return CollUtil.map((Collection)bean2, beanEle -> BeanUtil.getFieldValue(beanEle, fieldNameOrIndex), false);
            }
        }
        if (ArrayUtil.isArray(bean2)) {
            try {
                return ArrayUtil.get(bean2, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return ArrayUtil.map(bean2, Object.class, beanEle -> BeanUtil.getFieldValue(beanEle, fieldNameOrIndex));
            }
        }
        return ReflectUtil.getFieldValue(bean2, fieldNameOrIndex);
    }

    public static void setFieldValue(Object bean2, String fieldNameOrIndex, Object value) {
        if (bean2 instanceof Map) {
            ((Map)bean2).put(fieldNameOrIndex, value);
        } else if (bean2 instanceof List) {
            CollUtil.setOrAppend((List)bean2, Convert.toInt(fieldNameOrIndex), value);
        } else if (ArrayUtil.isArray(bean2)) {
            ArrayUtil.setOrAppend(bean2, (int)Convert.toInt(fieldNameOrIndex), value);
        } else {
            ReflectUtil.setFieldValue(bean2, fieldNameOrIndex, value);
        }
    }

    public static <T> T getProperty(Object bean2, String expression) {
        if (null == bean2 || StrUtil.isBlank(expression)) {
            return null;
        }
        return (T)BeanPath.create(expression).get(bean2);
    }

    public static void setProperty(Object bean2, String expression, Object value) {
        BeanPath.create(expression).set(bean2, value);
    }

    @Deprecated
    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    @Deprecated
    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMapIgnoreCase(map, ReflectUtil.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    @Deprecated
    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(beanClass), copyOptions);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isToCamelCase, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, ReflectUtil.newInstanceIfPossible(beanClass), isToCamelCase, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean2, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean2, false, isIgnoreError);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean2, boolean isToCamelCase, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean2, isToCamelCase, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean2, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean2, CopyOptions.create().setIgnoreCase(true).setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean2, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, bean2, false, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean2, boolean isToCamelCase, CopyOptions copyOptions) {
        if (MapUtil.isEmpty(map)) {
            return bean2;
        }
        if (isToCamelCase) {
            map = MapUtil.toCamelCaseMap(map);
        }
        BeanUtil.copyProperties(map, bean2, copyOptions);
        return bean2;
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        return BeanUtil.toBean(source, clazz, null);
    }

    public static <T> T toBeanIgnoreError(Object source, Class<T> clazz) {
        return BeanUtil.toBean(source, clazz, CopyOptions.create().setIgnoreError(true));
    }

    public static <T> T toBeanIgnoreCase(Object source, Class<T> clazz, boolean ignoreError) {
        return BeanUtil.toBean(source, clazz, CopyOptions.create().setIgnoreCase(true).setIgnoreError(ignoreError));
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        if (null == source) {
            return null;
        }
        T target = ReflectUtil.newInstanceIfPossible(clazz);
        BeanUtil.copyProperties(source, target, options);
        return target;
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == beanClass || null == valueProvider) {
            return null;
        }
        return BeanUtil.fillBean(ReflectUtil.newInstanceIfPossible(beanClass), valueProvider, copyOptions);
    }

    public static <T> T fillBean(T bean2, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean2;
        }
        return BeanCopier.create(valueProvider, bean2, copyOptions).copy();
    }

    public static Map<String, Object> beanToMap(Object bean2) {
        return BeanUtil.beanToMap(bean2, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean2, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean2) {
            return null;
        }
        return BeanUtil.beanToMap(bean2, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean2, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean2) {
            return null;
        }
        return BeanUtil.beanToMap(bean2, targetMap, ignoreNullValue, key -> isToUnderlineCase ? StrUtil.toUnderlineCase(key) : key);
    }

    public static Map<String, Object> beanToMap(Object bean2, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        if (null == bean2) {
            return null;
        }
        return BeanCopier.create(bean2, targetMap, CopyOptions.create().setIgnoreNullValue(ignoreNullValue).setFieldNameEditor(keyEditor)).copy();
    }

    public static <T> T copyProperties(Object source, Class<T> tClass, String ... ignoreProperties) {
        T target = ReflectUtil.newInstanceIfPossible(tClass);
        BeanUtil.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
        return target;
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtil.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, boolean ignoreCase) {
        BeanCopier.create(source, target, CopyOptions.create().setIgnoreCase(ignoreCase)).copy();
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        BeanCopier.create(source, target, ObjectUtil.defaultIfNull(copyOptions, CopyOptions.create())).copy();
    }

    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType, CopyOptions copyOptions) {
        if (null == collection) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList(0);
        }
        return collection.stream().map(source -> {
            Object target = ReflectUtil.newInstanceIfPossible(targetType);
            BeanUtil.copyProperties(source, target, copyOptions);
            return target;
        }).collect(Collectors.toList());
    }

    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType) {
        return BeanUtil.copyToList(collection, targetType, CopyOptions.create());
    }

    public static boolean isMatchName(Object bean2, String beanClassName, boolean isSimple) {
        if (null == bean2 || StrUtil.isBlank(beanClassName)) {
            return false;
        }
        return ClassUtil.getClassName(bean2, isSimple).equals(isSimple ? StrUtil.upperFirst(beanClassName) : beanClassName);
    }

    public static <T> T edit(T bean2, Editor<Field> editor) {
        Field[] fields;
        if (bean2 == null) {
            return null;
        }
        for (Field field : fields = ReflectUtil.getFields(bean2.getClass())) {
            if (ModifierUtil.isStatic(field)) continue;
            editor.edit(field);
        }
        return bean2;
    }

    public static <T> T trimStrFields(T bean2, String ... ignoreFields) {
        return BeanUtil.edit(bean2, field -> {
            String trimVal;
            String val;
            if (ignoreFields != null && ArrayUtil.containsIgnoreCase(ignoreFields, field.getName())) {
                return field;
            }
            if (String.class.equals(field.getType()) && null != (val = (String)ReflectUtil.getFieldValue(bean2, field)) && !val.equals(trimVal = StrUtil.trim(val))) {
                ReflectUtil.setFieldValue(bean2, field, (Object)trimVal);
            }
            return field;
        });
    }

    public static boolean isNotEmpty(Object bean2, String ... ignoreFiledNames) {
        return false == BeanUtil.isEmpty(bean2, ignoreFiledNames);
    }

    public static boolean isEmpty(Object bean2, String ... ignoreFiledNames) {
        if (null != bean2) {
            for (Field field : ReflectUtil.getFields(bean2.getClass())) {
                if (ModifierUtil.isStatic(field) || ArrayUtil.contains(ignoreFiledNames, field.getName()) || null == ReflectUtil.getFieldValue(bean2, field)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNullField(Object bean2, String ... ignoreFiledNames) {
        if (null == bean2) {
            return true;
        }
        for (Field field : ReflectUtil.getFields(bean2.getClass())) {
            if (ModifierUtil.isStatic(field) || ArrayUtil.contains(ignoreFiledNames, field.getName()) || null != ReflectUtil.getFieldValue(bean2, field)) continue;
            return true;
        }
        return false;
    }
}

