/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.miniapp.config.storage;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedissonConfigImpl;
import com.binarywang.spring.starter.wxjava.miniapp.config.storage.AbstractWxMaConfigStorageConfiguration;
import com.binarywang.spring.starter.wxjava.miniapp.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaProperties;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.TransportMode;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="wx.miniapp.config-storage", name={"type"}, havingValue="redisson")
@ConditionalOnClass(value={Redisson.class, RedissonClient.class})
public class WxMaInRedissonConfigStorageConfiguration
extends AbstractWxMaConfigStorageConfiguration {
    private final WxMaProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxMaConfig.class})
    public WxMaConfig wxMaConfig() {
        WxMaRedissonConfigImpl config = this.getWxMaInRedissonConfigStorage();
        return this.config((WxMaDefaultConfigImpl)config, this.properties);
    }

    private WxMaRedissonConfigImpl getWxMaInRedissonConfigStorage() {
        RedisProperties redisProperties = this.properties.getConfigStorage().getRedis();
        RedissonClient redissonClient = redisProperties != null && StringUtils.isNotEmpty((CharSequence)redisProperties.getHost()) ? this.getRedissonClient() : (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
        return new WxMaRedissonConfigImpl(redissonClient, this.properties.getConfigStorage().getKeyPrefix());
    }

    private RedissonClient getRedissonClient() {
        WxMaProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        Config config = new Config();
        config.useSingleServer().setAddress("redis://" + redis.getHost() + ":" + redis.getPort()).setDatabase(redis.getDatabase()).setPassword(redis.getPassword());
        config.setTransportMode(TransportMode.NIO);
        return Redisson.create((Config)config);
    }

    public WxMaInRedissonConfigStorageConfiguration(WxMaProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

