/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxWithholdOrderQueryRequest
extends BaseWxPayRequest {
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isNotBlank((CharSequence)this.transactionId) && StringUtils.isNotBlank((CharSequence)this.outTradeNo)) {
            throw new WxPayException("transactionId \u548c outTradeNo \u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u4e8c\u9009\u4e00");
        }
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("transaction_id", this.transactionId);
        map.put("out_trade_no", this.outTradeNo);
    }

    public static WxWithholdOrderQueryRequestBuilder newBuilder() {
        return new WxWithholdOrderQueryRequestBuilder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    @Override
    public String toString() {
        return "WxWithholdOrderQueryRequest(transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxWithholdOrderQueryRequest)) {
            return false;
        }
        WxWithholdOrderQueryRequest other = (WxWithholdOrderQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        return !(this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxWithholdOrderQueryRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        return result;
    }

    public WxWithholdOrderQueryRequest() {
    }

    public WxWithholdOrderQueryRequest(String transactionId, String outTradeNo) {
        this.transactionId = transactionId;
        this.outTradeNo = outTradeNo;
    }

    public static class WxWithholdOrderQueryRequestBuilder {
        private String transactionId;
        private String outTradeNo;

        WxWithholdOrderQueryRequestBuilder() {
        }

        public WxWithholdOrderQueryRequestBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public WxWithholdOrderQueryRequestBuilder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public WxWithholdOrderQueryRequest build() {
            return new WxWithholdOrderQueryRequest(this.transactionId, this.outTradeNo);
        }

        public String toString() {
            return "WxWithholdOrderQueryRequest.WxWithholdOrderQueryRequestBuilder(transactionId=" + this.transactionId + ", outTradeNo=" + this.outTradeNo + ")";
        }
    }
}

