/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.bean.message;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.util.WxOpenCryptUtil;
import me.chanjar.weixin.open.util.xml.XStreamTransformer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="xml")
public class WxOpenXmlMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(WxOpenXmlMessage.class);
    private static final long serialVersionUID = -5641769554709507771L;
    @XStreamAlias(value="AppId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String appId;
    @XStreamAlias(value="CreateTime")
    private Long createTime;
    @XStreamAlias(value="InfoType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String infoType;
    @XStreamAlias(value="ComponentVerifyTicket")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String componentVerifyTicket;
    @XStreamAlias(value="AuthorizerAppid")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String authorizerAppid;
    @XStreamAlias(value="AuthorizationCode")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String authorizationCode;
    @XStreamAlias(value="AuthorizationCodeExpiredTime")
    private Long authorizationCodeExpiredTime;
    @XStreamAlias(value="PreAuthCode")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String preAuthCode;

    public static String wxMpOutXmlMessageToEncryptedXml(WxMpXmlOutMessage message, WxOpenConfigStorage wxOpenConfigStorage) {
        String plainXml = message.toXml();
        WxOpenCryptUtil pc = new WxOpenCryptUtil(wxOpenConfigStorage);
        return pc.encrypt(plainXml);
    }

    public static WxOpenXmlMessage fromXml(String xml) {
        xml = xml.replace("</PicList><PicList>", "");
        return XStreamTransformer.fromXml(WxOpenXmlMessage.class, xml);
    }

    public static WxOpenXmlMessage fromXml(InputStream is) {
        return XStreamTransformer.fromXml(WxOpenXmlMessage.class, is);
    }

    public static WxOpenXmlMessage fromEncryptedXml(String encryptedXml, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        WxOpenCryptUtil cryptUtil = new WxOpenCryptUtil(wxOpenConfigStorage);
        String plainText = cryptUtil.decrypt(msgSignature, timestamp, nonce, encryptedXml);
        log.debug("\u89e3\u5bc6\u540e\u7684\u539f\u59cbxml\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)plainText);
        return WxOpenXmlMessage.fromXml(plainText);
    }

    public static WxMpXmlMessage fromEncryptedMpXml(String encryptedXml, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        WxOpenCryptUtil cryptUtil = new WxOpenCryptUtil(wxOpenConfigStorage);
        String plainText = cryptUtil.decrypt(msgSignature, timestamp, nonce, encryptedXml);
        return WxMpXmlMessage.fromXml((String)plainText);
    }

    public static WxOpenXmlMessage fromEncryptedXml(InputStream is, WxOpenConfigStorage wxOpenConfigStorage, String timestamp, String nonce, String msgSignature) {
        try {
            return WxOpenXmlMessage.fromEncryptedXml(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), wxOpenConfigStorage, timestamp, nonce, msgSignature);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getInfoType() {
        return this.infoType;
    }

    public String getComponentVerifyTicket() {
        return this.componentVerifyTicket;
    }

    public String getAuthorizerAppid() {
        return this.authorizerAppid;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public Long getAuthorizationCodeExpiredTime() {
        return this.authorizationCodeExpiredTime;
    }

    public String getPreAuthCode() {
        return this.preAuthCode;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    public void setComponentVerifyTicket(String componentVerifyTicket) {
        this.componentVerifyTicket = componentVerifyTicket;
    }

    public void setAuthorizerAppid(String authorizerAppid) {
        this.authorizerAppid = authorizerAppid;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public void setAuthorizationCodeExpiredTime(Long authorizationCodeExpiredTime) {
        this.authorizationCodeExpiredTime = authorizationCodeExpiredTime;
    }

    public void setPreAuthCode(String preAuthCode) {
        this.preAuthCode = preAuthCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxOpenXmlMessage)) {
            return false;
        }
        WxOpenXmlMessage other = (WxOpenXmlMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$infoType = this.getInfoType();
        String other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !this$infoType.equals(other$infoType)) {
            return false;
        }
        String this$componentVerifyTicket = this.getComponentVerifyTicket();
        String other$componentVerifyTicket = other.getComponentVerifyTicket();
        if (this$componentVerifyTicket == null ? other$componentVerifyTicket != null : !this$componentVerifyTicket.equals(other$componentVerifyTicket)) {
            return false;
        }
        String this$authorizerAppid = this.getAuthorizerAppid();
        String other$authorizerAppid = other.getAuthorizerAppid();
        if (this$authorizerAppid == null ? other$authorizerAppid != null : !this$authorizerAppid.equals(other$authorizerAppid)) {
            return false;
        }
        String this$authorizationCode = this.getAuthorizationCode();
        String other$authorizationCode = other.getAuthorizationCode();
        if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
            return false;
        }
        Long this$authorizationCodeExpiredTime = this.getAuthorizationCodeExpiredTime();
        Long other$authorizationCodeExpiredTime = other.getAuthorizationCodeExpiredTime();
        if (this$authorizationCodeExpiredTime == null ? other$authorizationCodeExpiredTime != null : !((Object)this$authorizationCodeExpiredTime).equals(other$authorizationCodeExpiredTime)) {
            return false;
        }
        String this$preAuthCode = this.getPreAuthCode();
        String other$preAuthCode = other.getPreAuthCode();
        return !(this$preAuthCode == null ? other$preAuthCode != null : !this$preAuthCode.equals(other$preAuthCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxOpenXmlMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : $infoType.hashCode());
        String $componentVerifyTicket = this.getComponentVerifyTicket();
        result = result * 59 + ($componentVerifyTicket == null ? 43 : $componentVerifyTicket.hashCode());
        String $authorizerAppid = this.getAuthorizerAppid();
        result = result * 59 + ($authorizerAppid == null ? 43 : $authorizerAppid.hashCode());
        String $authorizationCode = this.getAuthorizationCode();
        result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
        Long $authorizationCodeExpiredTime = this.getAuthorizationCodeExpiredTime();
        result = result * 59 + ($authorizationCodeExpiredTime == null ? 43 : ((Object)$authorizationCodeExpiredTime).hashCode());
        String $preAuthCode = this.getPreAuthCode();
        result = result * 59 + ($preAuthCode == null ? 43 : $preAuthCode.hashCode());
        return result;
    }

    public String toString() {
        return "WxOpenXmlMessage(appId=" + this.getAppId() + ", createTime=" + this.getCreateTime() + ", infoType=" + this.getInfoType() + ", componentVerifyTicket=" + this.getComponentVerifyTicket() + ", authorizerAppid=" + this.getAuthorizerAppid() + ", authorizationCode=" + this.getAuthorizationCode() + ", authorizationCodeExpiredTime=" + this.getAuthorizationCodeExpiredTime() + ", preAuthCode=" + this.getPreAuthCode() + ")";
    }
}

