/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.IOException;
import java.util.Objects;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.common.util.http.okhttp.DefaultOkHttpClientBuilder;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.mp.api.impl.BaseWxMpServiceImpl;
import me.chanjar.weixin.mp.bean.WxMpStableAccessTokenRequest;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class WxMpServiceOkHttpImpl
extends BaseWxMpServiceImpl<OkHttpClient, OkHttpProxyInfo> {
    private OkHttpClient httpClient;
    private OkHttpProxyInfo httpProxy;

    public OkHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.OK_HTTP;
    }

    @Override
    public void initHttp() {
        WxMpConfigStorage wxMpConfigStorage = this.getWxMpConfigStorage();
        if (wxMpConfigStorage.getHttpProxyHost() != null && wxMpConfigStorage.getHttpProxyPort() > 0) {
            this.httpProxy = OkHttpProxyInfo.httpProxy((String)wxMpConfigStorage.getHttpProxyHost(), (int)wxMpConfigStorage.getHttpProxyPort(), (String)wxMpConfigStorage.getHttpProxyUsername(), (String)wxMpConfigStorage.getHttpProxyPassword());
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
            clientBuilder.proxyAuthenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)WxMpServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxMpServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            });
            this.httpClient = clientBuilder.build();
        } else {
            this.httpClient = DefaultOkHttpClientBuilder.get().build();
        }
    }

    @Override
    protected String doGetAccessTokenRequest() throws IOException {
        String url = String.format(WxMpApiUrl.Other.GET_ACCESS_TOKEN_URL.getUrl(this.getWxMpConfigStorage()), this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret());
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = this.getRequestHttpClient().newCall(request).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }

    @Override
    protected String doGetStableAccessTokenRequest(boolean forceRefresh) throws IOException {
        String url = WxMpApiUrl.Other.GET_STABLE_ACCESS_TOKEN_URL.getUrl(this.getWxMpConfigStorage());
        WxMpStableAccessTokenRequest wxMaAccessTokenRequest = new WxMpStableAccessTokenRequest();
        wxMaAccessTokenRequest.setAppid(this.getWxMpConfigStorage().getAppId());
        wxMaAccessTokenRequest.setSecret(this.getWxMpConfigStorage().getSecret());
        wxMaAccessTokenRequest.setGrantType("client_credential");
        wxMaAccessTokenRequest.setForceRefresh(forceRefresh);
        RequestBody body = RequestBody.Companion.create(wxMaAccessTokenRequest.toJson(), MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.getRequestHttpClient().newCall(request).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }
}

