/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.json;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import jodd.util.MathUtil;
import me.chanjar.weixin.common.error.WxRuntimeException;

public class GsonHelper {
    public static boolean isNull(JsonElement element) {
        return element == null || element.isJsonNull();
    }

    public static boolean isNotNull(JsonElement element) {
        return !GsonHelper.isNull(element);
    }

    public static Long getLong(JsonObject json, String property) {
        return GsonHelper.getAsLong(json.get(property));
    }

    public static long getPrimitiveLong(JsonObject json, String property) {
        return GsonHelper.getAsPrimitiveLong(json.get(property));
    }

    public static Integer getInteger(JsonObject json, String property) {
        return GsonHelper.getAsInteger(json.get(property));
    }

    public static int getPrimitiveInteger(JsonObject json, String property) {
        return GsonHelper.getAsPrimitiveInt(json.get(property));
    }

    public static Double getDouble(JsonObject json, String property) {
        return GsonHelper.getAsDouble(json.get(property));
    }

    public static double getPrimitiveDouble(JsonObject json, String property) {
        return GsonHelper.getAsPrimitiveDouble(json.get(property));
    }

    public static Float getFloat(JsonObject json, String property) {
        return GsonHelper.getAsFloat(json.get(property));
    }

    public static float getPrimitiveFloat(JsonObject json, String property) {
        return GsonHelper.getAsPrimitiveFloat(json.get(property));
    }

    public static Boolean getBoolean(JsonObject json, String property) {
        return GsonHelper.getAsBoolean(json.get(property));
    }

    public static String getString(JsonObject json, String property) {
        return GsonHelper.getAsString(json.get(property));
    }

    public static String getAsString(JsonElement element) {
        return GsonHelper.isNull(element) ? null : element.getAsString();
    }

    public static Long getAsLong(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Long.valueOf(element.getAsLong());
    }

    public static long getAsPrimitiveLong(JsonElement element) {
        Long r = GsonHelper.getAsLong(element);
        return r == null ? 0L : r;
    }

    public static Integer getAsInteger(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Integer.valueOf(element.getAsInt());
    }

    public static int getAsPrimitiveInt(JsonElement element) {
        Integer r = GsonHelper.getAsInteger(element);
        return r == null ? 0 : r;
    }

    public static Boolean getAsBoolean(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Boolean.valueOf(element.getAsBoolean());
    }

    public static boolean getAsPrimitiveBool(JsonElement element) {
        Boolean r = GsonHelper.getAsBoolean(element);
        return r != null && r != false;
    }

    public static Double getAsDouble(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Double.valueOf(element.getAsDouble());
    }

    public static double getAsPrimitiveDouble(JsonElement element) {
        Double r = GsonHelper.getAsDouble(element);
        return r == null ? 0.0 : r;
    }

    public static Float getAsFloat(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Float.valueOf(element.getAsFloat());
    }

    public static float getAsPrimitiveFloat(JsonElement element) {
        Float r = GsonHelper.getAsFloat(element);
        return r == null ? 0.0f : r.floatValue();
    }

    public static Integer[] getIntArray(JsonObject o, String string) {
        JsonArray jsonArray = GsonHelper.getAsJsonArray((JsonElement)o.getAsJsonArray(string));
        if (jsonArray == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < jsonArray.size(); ++i) {
            result.add(jsonArray.get(i).getAsInt());
        }
        return result.toArray(new Integer[0]);
    }

    public static String[] getStringArray(JsonObject o, String string) {
        JsonArray jsonArray = GsonHelper.getAsJsonArray((JsonElement)o.getAsJsonArray(string));
        if (jsonArray == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < jsonArray.size(); ++i) {
            result.add(jsonArray.get(i).getAsString());
        }
        return result.toArray(new String[0]);
    }

    public static Long[] getLongArray(JsonObject o, String string) {
        JsonArray jsonArray = GsonHelper.getAsJsonArray((JsonElement)o.getAsJsonArray(string));
        if (jsonArray == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < jsonArray.size(); ++i) {
            result.add(jsonArray.get(i).getAsLong());
        }
        return result.toArray(new Long[0]);
    }

    public static JsonArray getAsJsonArray(JsonElement element) {
        return element == null ? null : element.getAsJsonArray();
    }

    public static JsonObject buildJsonObject(Object ... keyOrValue) {
        JsonObject result = new JsonObject();
        GsonHelper.put(result, keyOrValue);
        return result;
    }

    public static void put(JsonObject jsonObject, Object ... keyOrValue) {
        if (MathUtil.isOdd((int)keyOrValue.length)) {
            throw new WxRuntimeException("\u53c2\u6570\u4e2a\u6570\u5fc5\u987b\u4e3a\u5076\u6570");
        }
        for (int i = 0; i < keyOrValue.length / 2; ++i) {
            Object key = keyOrValue[2 * i];
            Object value = keyOrValue[2 * i + 1];
            if (value == null) {
                jsonObject.add(key.toString(), null);
                continue;
            }
            if (value instanceof Boolean) {
                jsonObject.addProperty(key.toString(), (Boolean)value);
                continue;
            }
            if (value instanceof Character) {
                jsonObject.addProperty(key.toString(), (Character)value);
                continue;
            }
            if (value instanceof Number) {
                jsonObject.addProperty(key.toString(), (Number)value);
                continue;
            }
            if (value instanceof JsonElement) {
                jsonObject.add(key.toString(), (JsonElement)value);
                continue;
            }
            jsonObject.addProperty(key.toString(), value.toString());
        }
    }
}

