/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.mybatis.scanner;

import cn.org.atool.fluent.mybatis.base.BaseEntity;
import cn.org.atool.fluent.mybatis.base.RichEntity;
import cn.org.atool.fluent.processor.AScanner;
import cn.org.atool.fluent.processor.mybatis.entity.FluentEntity;
import java.util.Objects;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class FluentScanner2
extends AScanner {
    private final FluentEntity fluent = new FluentEntity();

    public FluentScanner2(Messager messager) {
        super(messager);
    }

    @Override
    public FluentScanner2 scan(TypeElement element) {
        this.fluent.parseEntity(element, err -> this.messager.printMessage(Diagnostic.Kind.ERROR, (CharSequence)err));
        while (!this.isBaseEntity(element)) {
            for (Element element2 : element.getEnclosedElements()) {
                this.visitElement(element2);
            }
            TypeMirror typeMirror = element.getSuperclass();
            if (typeMirror instanceof NoType) break;
            element = this.asTypeElement(typeMirror);
        }
        return this;
    }

    private void visitElement(Element item) {
        if (item instanceof VariableElement) {
            this.fluent.visitVariable((VariableElement)item);
        }
        if (item instanceof ExecutableElement) {
            this.fluent.addMethod((ExecutableElement)item);
        }
    }

    private boolean isBaseEntity(TypeElement element) {
        String name = element.toString();
        if (Objects.equals(BaseEntity.class.getName(), name)) {
            return true;
        }
        if (Objects.equals(RichEntity.class.getName(), name)) {
            return true;
        }
        return Objects.equals(Object.class.getName(), name);
    }

    public FluentEntity getFluent() {
        return this.fluent;
    }
}

