/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.mybatis.scanner;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ClassAttrParser {
    public static final String ATTR_DEFAULTS = "defaults()";
    public static final String ATTR_SUPER_MAPPER = "superMapper()";

    public static String getClassAttr(TypeElement klass, Class<? extends Annotation> annotationType, String methodName, Class defaultValue) {
        AnnotationMirror mirror = ClassAttrParser.getFluentMyBatisMirror(klass, annotationType);
        if (mirror == null) {
            return defaultValue.getName();
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement method = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!method.toString().contains(methodName)) continue;
            String aClass = value.getValue().toString();
            return Objects.equals(aClass, Object.class.getName()) ? defaultValue.getName() : aClass;
        }
        return defaultValue.getName();
    }

    private static AnnotationMirror getFluentMyBatisMirror(TypeElement entity, Class<? extends Annotation> annotationType) {
        List<? extends AnnotationMirror> annotations = entity.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().toString().contains(annotationType.getSimpleName())) continue;
            return annotationMirror;
        }
        return null;
    }
}

