/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.mybatis.filer.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IDefaultSetter;
import cn.org.atool.fluent.mybatis.base.entity.AMapping;
import cn.org.atool.fluent.mybatis.base.entity.TableId;
import cn.org.atool.fluent.mybatis.base.model.UniqueType;
import cn.org.atool.fluent.mybatis.functions.StringSupplier;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.fragment.Fragments;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.processor.mybatis.base.FluentClassName;
import cn.org.atool.fluent.processor.mybatis.entity.CommonField;
import cn.org.atool.fluent.processor.mybatis.entity.EntityRefMethod;
import cn.org.atool.fluent.processor.mybatis.entity.FieldOrMethod;
import cn.org.atool.fluent.processor.mybatis.entity.FluentEntity;
import cn.org.atool.fluent.processor.mybatis.entity.PrimaryField;
import cn.org.atool.fluent.processor.mybatis.filer.AbstractFiler;
import cn.org.atool.fluent.processor.mybatis.filer.ClassNames2;
import cn.org.atool.fluent.processor.mybatis.filer.FilerKit;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class EntityMappingFiler
extends AbstractFiler {
    public static String getClassName(FluentClassName fluent) {
        return fluent.getNoSuffix() + "Mapping";
    }

    public static String getPackageName(FluentClassName fluent) {
        return fluent.getPackageName("helper");
    }

    public EntityMappingFiler(FluentEntity fluent) {
        super(fluent);
        this.packageName = EntityMappingFiler.getPackageName(fluent);
        this.klassName = EntityMappingFiler.getClassName(fluent);
        this.comment = "Entity\u5e2e\u52a9\u7c7b";
    }

    @Override
    protected void staticImport(JavaFile.Builder spec) {
        spec.addStaticImport(UniqueType.class, new String[]{"*"});
        spec.addStaticImport(Fragments.class, new String[]{"fragment"});
        spec.skipJavaLangImports(true);
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.superclass(this.paraType(ClassName.get(AMapping.class), this.fluent.entity(), this.fluent.query(), this.fluent.updater())).addField(this.f_Table_Name()).addField(this.f_Entity_Name());
        for (CommonField f : this.fluent.getFields()) {
            spec.addField(this.f_Field(f));
        }
        spec.addField(this.f_defaultSetter()).addField(this.f_allFieldMapping()).addField(this.f_instance());
        spec.addMethod(this.m_constructor()).addMethod(this.m_entityClass()).addMethod(this.m_mapperClass()).addMethod(this.m_newEntity()).addMethod(this.m_allFields()).addMethod(this.m_defaultSetter()).addMethod(this.m_newQuery()).addMethod(this.m_newUpdater());
    }

    private FieldSpec f_Table_Name() {
        return FieldSpec.builder(String.class, (String)"TABLE_NAME", (Modifier[])FilerKit.PUBLIC_STATIC_FINAL).initializer("$S", new Object[]{this.fluent.getTableName()}).addJavadoc(super.codeBlock("\u8868\u540d\u79f0")).build();
    }

    private FieldSpec f_Entity_Name() {
        return FieldSpec.builder(String.class, (String)"ENTITY_NAME", (Modifier[])FilerKit.PUBLIC_STATIC_FINAL).initializer("$S", new Object[]{this.fluent.getClassName()}).addJavadoc(super.codeBlock("Entity\u540d\u79f0")).build();
    }

    private FieldSpec f_instance() {
        return FieldSpec.builder((TypeName)this.fluent.entityMapping(), (String)"MAPPING", (Modifier[])FilerKit.PUBLIC_STATIC_FINAL).initializer("new $T()", new Object[]{this.fluent.entityMapping()}).build();
    }

    private FieldSpec f_allFieldMapping() {
        String fields = this.fluent.getFields().stream().map(FieldOrMethod::getName).collect(Collectors.joining(", "));
        return FieldSpec.builder((TypeName)ClassNames2.CN_List_FMapping, (String)"ALL_FIELD_MAPPING", (Modifier[])FilerKit.PUBLIC_STATIC_FINAL).initializer("$T.unmodifiableList($T\n\t.asList($L))", new Object[]{Collections.class, Arrays.class, fields}).build();
    }

    private FieldSpec f_Field(CommonField f) {
        String name = f.getName();
        FieldSpec.Builder spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassNames2.FN_FieldMapping, (TypeName[])new TypeName[]{this.fluent.entity()}), (String)f.getName(), (Modifier[])FilerKit.PUBLIC_STATIC_FINAL).addJavadoc("\u5b9e\u4f53\u5c5e\u6027 : \u6570\u636e\u5e93\u5b57\u6bb5 \u6620\u5c04\n $L : $L", new Object[]{name, f.getColumn()});
        UniqueType type = this.getUniqueType(f);
        CodeBlock.Builder init = CodeBlock.builder();
        init.add("new FieldMapping<$T>", new Object[]{this.fluent.entity()});
        init.add("\n\t(", new Object[0]).add("$L, $L, ", new Object[]{this.quota(name), this.quota(f.getColumn())}).add(type == null ? "null" : type.name(), new Object[0]).add(", $L, $L, ", new Object[]{this.quota(f.getInsert()), this.quota(f.getUpdate())}).add("$T.class, ", new Object[]{f.getJavaType()});
        if (f.getTypeHandler() == null) {
            init.add("null)", new Object[0]);
        } else {
            init.add("$T.class)", new Object[]{f.getTypeHandler()});
        }
        init.add("\n\t.sg((e, v) -> e.$L(($T) v), $T::$L)", new Object[]{f.setMethodName(), f.getJavaType(), this.fluent.entity(), f.getMethodName()});
        return spec.initializer(init.build()).build();
    }

    private UniqueType getUniqueType(CommonField field) {
        if (field.isPrimary()) {
            return UniqueType.PRIMARY_ID;
        }
        if (Objects.equals(field.getName(), this.fluent.getVersionField())) {
            return UniqueType.LOCK_VERSION;
        }
        if (Objects.equals(field.getName(), this.fluent.getLogicDelete())) {
            return UniqueType.LOGIC_DELETED;
        }
        return null;
    }

    private FieldSpec f_defaultSetter() {
        ClassName type = ClassNames2.getClassName(this.fluent.getDefaults());
        return FieldSpec.builder((TypeName)type, (String)"DEFAULT_SETTER", (Modifier[])new Modifier[0]).addModifiers(FilerKit.PUBLIC_STATIC_FINAL).initializer("new $T(){}", new Object[]{type}).build();
    }

    private MethodSpec m_constructor() {
        MethodSpec.Builder spec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addStatement("super($T.$L)", new Object[]{DbType.class, this.fluent.getDbType().name()}).addStatement("super.tableName = TABLE_NAME", new Object[0]);
        PrimaryField p = this.fluent.getPrimary();
        if (p != null) {
            spec.addStatement("super.tableId = new $T($S, $S, $L, $S, $L)", new Object[]{TableId.class, p.getName(), p.getColumn(), p.isAutoIncrease(), p.getSeqName(), p.isSeqIsBeforeOrder()});
        }
        this.putUniqueField(spec);
        this.addRef(spec);
        return spec.build();
    }

    private void addRef(MethodSpec.Builder spec) {
        String del = "\";\"";
        for (EntityRefMethod m : this.fluent.getRefMethods()) {
            if (m.getMapping().isEmpty()) {
                spec.addStatement("super.ref($S, $L, $T::$L)", new Object[]{m.getName(), m.returnList(), this.fluent.entity(), m.getName()});
                continue;
            }
            StringBuilder src = new StringBuilder(del);
            StringBuilder ref = new StringBuilder(del);
            for (Map.Entry<String, String> entry : m.getMapping().entrySet()) {
                src.append(" + e.get").append(MybatisUtil.capitalFirst((String)entry.getValue())).append("() + ").append(del);
                ref.append(" + e.get").append(MybatisUtil.capitalFirst((String)entry.getKey())).append("() + ").append(del);
            }
            spec.addStatement("super.ref($S, e -> $L, $L, ($T e) -> $L, $T::$L)", new Object[]{m.getName(), src, m.returnList(), m.getReturnType(), ref, this.fluent.entity(), m.getName()});
        }
        spec.addStatement("super.Ref_Keys.unmodified()", new Object[0]);
    }

    private MethodSpec m_newEntity() {
        return FilerKit.publicMethod("newEntity", (TypeName)TypeVariableName.get((String)"E")).addTypeVariable(TypeVariableName.get((String)"E", (Type[])new Type[]{IEntity.class})).addStatement("return (E) new $T()", new Object[]{this.fluent.entity()}).build();
    }

    private MethodSpec m_allFields() {
        MethodSpec.Builder spec = FilerKit.publicMethod("allFields", (TypeName)ClassNames2.CN_List_FMapping);
        spec.addModifiers(FilerKit.PUBLIC_FINAL).addStatement("return ALL_FIELD_MAPPING", new Object[0]);
        return spec.build();
    }

    private void putUniqueField(MethodSpec.Builder spec) {
        if (this.fluent.getPrimary() != null) {
            spec.addStatement("super.uniqueFields.put(PRIMARY_ID, $L)", new Object[]{this.fluent.getPrimary().getName()});
        }
        if (If.notBlank((CharSequence)this.fluent.getLogicDelete())) {
            spec.addStatement("super.uniqueFields.put(LOGIC_DELETED, $L)", new Object[]{this.fluent.getLogicDelete()});
        }
        if (If.notBlank((CharSequence)this.fluent.getVersionField())) {
            spec.addStatement("super.uniqueFields.put(LOCK_VERSION, $L)", new Object[]{this.fluent.getVersionField()});
        }
    }

    private MethodSpec m_entityClass() {
        return FilerKit.publicMethod("entityClass", Class.class).addStatement("return $T.class", new Object[]{this.fluent.entity()}).build();
    }

    private MethodSpec m_mapperClass() {
        return FilerKit.publicMethod("mapperClass", Class.class).addStatement("return $T.class", new Object[]{this.fluent.mapper()}).build();
    }

    private MethodSpec m_newQuery() {
        return FilerKit.protectMethod("query", (TypeName)this.fluent.query()).addModifiers(new Modifier[]{Modifier.FINAL}).addParameter(Boolean.TYPE, "defaults", new Modifier[0]).addParameter(StringSupplier.class, "table", new Modifier[0]).addParameter(StringSupplier.class, "alias", new Modifier[0]).addParameter(Parameters.class, "shared", new Modifier[0]).addStatement("return new $T(defaults, fragment(table), alias, shared)", new Object[]{this.fluent.query()}).build();
    }

    private MethodSpec m_newUpdater() {
        return FilerKit.protectMethod("updater", (TypeName)this.fluent.updater()).addModifiers(new Modifier[]{Modifier.FINAL}).addParameter(Boolean.TYPE, "defaults", new Modifier[0]).addParameter(StringSupplier.class, "table", new Modifier[0]).addParameter(StringSupplier.class, "alias", new Modifier[0]).addParameter(Parameters.class, "shared", new Modifier[0]).addStatement("return new $T(defaults, fragment(table), alias, shared)", new Object[]{this.fluent.updater()}).build();
    }

    private MethodSpec m_defaultSetter() {
        return FilerKit.publicMethod("defaultSetter", IDefaultSetter.class).addStatement("return DEFAULT_SETTER", new Object[0]).build();
    }

    @Override
    protected boolean isInterface() {
        return false;
    }

    private String quota(String input) {
        return If.isBlank((CharSequence)input) ? null : '\"' + input + '\"';
    }
}

