/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.mybatis.filer.refs;

import cn.org.atool.fluent.mybatis.base.EntityRefKit;
import cn.org.atool.fluent.mybatis.base.intf.IRelation;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import cn.org.atool.fluent.processor.mybatis.entity.EntityRefMethod;
import cn.org.atool.fluent.processor.mybatis.entity.FluentEntity;
import cn.org.atool.fluent.processor.mybatis.entity.FluentList;
import cn.org.atool.fluent.processor.mybatis.filer.ClassNames2;
import cn.org.atool.fluent.processor.mybatis.filer.FilerKit;
import cn.org.atool.generator.javafile.AbstractFile;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class RelationFiler
extends AbstractFile {
    private static final String EntityRelation = "IEntityRelation";
    private final List<FluentEntity> fluents;

    public RelationFiler(String basePackage, List<FluentEntity> fluents) {
        this.packageName = basePackage;
        this.fluents = fluents;
        this.klassName = EntityRelation;
        this.comment = "\u5b9e\u4f53\u7c7b\u95f4\u81ea\u5b9a\u4e49\u7684\u5173\u8054\u5173\u7cfb\u63a5\u53e3";
    }

    protected void staticImport(JavaFile.Builder builder) {
        builder.addStaticImport(RefKit.class, new String[]{"put"});
        builder.addStaticImport(EntityRefKit.class, new String[]{"values"});
        builder.skipJavaLangImports(true);
    }

    protected void build(TypeSpec.Builder spec) {
        spec.addSuperinterface(IRelation.class);
        for (FluentEntity fluent : this.fluents) {
            for (EntityRefMethod method : fluent.getRefMethods()) {
                spec.addMethod(this.buildMethod(fluent, method));
            }
        }
        spec.addMethod(this.m_initialize());
    }

    private MethodSpec buildMethod(FluentEntity fluent, EntityRefMethod method) {
        if (method.isAbstractMethod()) {
            return this.m_abstractMethod(fluent, method);
        }
        return this.m_defaultMethod(fluent, method);
    }

    private MethodSpec m_abstractMethod(FluentEntity fluent, EntityRefMethod refField) {
        return MethodSpec.methodBuilder((String)refField.getRefMethod(fluent)).addParameter((TypeName)fluent.entity(), "entity", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(refField.getJavaType()).addJavadoc("{@link $L#$L()}", new Object[]{fluent.getClassName(), refField.getName()}).build();
    }

    private MethodSpec m_defaultMethod(FluentEntity fluent, EntityRefMethod refMethod) {
        FluentEntity ref = FluentList.getFluentEntity(refMethod.getReturnEntity());
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)refMethod.getRefMethod(fluent)).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassNames2.CN_List, (TypeName[])new TypeName[]{refMethod.getReturnType()})).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassNames2.CN_List, (TypeName[])new TypeName[]{fluent.entity()}), "entities", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addJavadoc("{@link $L#$L()}", new Object[]{fluent.getClassName(), refMethod.getName()});
        spec.addCode("return new $T()\n", new Object[]{ref.query()});
        int index = 0;
        for (Map.Entry<String, String> entry : refMethod.getMapping().entrySet()) {
            spec.addCode(index == 0 ? "\t.where" : "\t.and", new Object[0]).addCode(".$L().in(values(entities, $T::get$L))\n", new Object[]{entry.getKey(), fluent.entity(), MybatisUtil.capitalFirst((String)entry.getValue())});
            ++index;
        }
        spec.addStatement("\t.end().to().listEntity()", new Object[0]);
        return spec.build();
    }

    private MethodSpec m_initialize() {
        MethodSpec.Builder spec = FilerKit.publicMethod("initialize", (TypeName)null).addModifiers(new Modifier[]{Modifier.DEFAULT});
        ArrayList<CodeBlock> codes = new ArrayList<CodeBlock>();
        for (FluentEntity fluent : this.fluents) {
            for (EntityRefMethod method : fluent.getRefMethods()) {
                if (method.isAbstractMethod()) {
                    codes.add(CodeBlock.of((String)"put(this::$L);", (Object[])new Object[]{method.getRefMethod(fluent)}));
                    continue;
                }
                codes.add(CodeBlock.of((String)"put($T.class, $S, this::$L);", (Object[])new Object[]{fluent.entity(), method.getName(), method.getRefMethod(fluent)}));
            }
        }
        spec.addCode(CodeBlock.join(codes, (String)"\n"));
        return spec.build();
    }

    protected boolean isInterface() {
        return true;
    }
}

