/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.mybatis.filer;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public interface FilerKit {
    public static final Modifier[] PUBLIC_STATIC_FINAL = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};
    public static final Modifier[] PUBLIC_FINAL = new Modifier[]{Modifier.PUBLIC, Modifier.FINAL};
    public static final Modifier[] PRIVATE_STATIC_FINAL = new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL};
    public static final Modifier[] PRIVATE_STATIC = new Modifier[]{Modifier.PRIVATE, Modifier.STATIC};
    public static final Modifier[] PUBLIC_STATIC = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};

    public static MethodSpec.Builder staticMethod(String methodName, TypeName returnKlass) {
        return FilerKit.publicMethod(methodName, false, returnKlass).addModifiers(new Modifier[]{Modifier.STATIC});
    }

    public static MethodSpec.Builder staticMethod(String methodName, Class returnKlass) {
        return FilerKit.publicMethod(methodName, false, (TypeName)ClassName.get((Class)returnKlass)).addModifiers(new Modifier[]{Modifier.STATIC});
    }

    public static MethodSpec.Builder publicMethod(String methodName, boolean isOverride, TypeName returnKlass) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName);
        if (isOverride) {
            builder.addAnnotation(Override.class);
        }
        if (returnKlass != null) {
            builder.returns(returnKlass);
        }
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        return builder;
    }

    public static MethodSpec.Builder publicMethod(String methodName, Class returnKlass) {
        return FilerKit.publicMethod(methodName, true, (TypeName)(returnKlass == null ? null : ClassName.get((Class)returnKlass)));
    }

    public static MethodSpec.Builder publicMethod(String methodName, TypeName returnKlass) {
        return FilerKit.publicMethod(methodName, true, returnKlass);
    }

    public static MethodSpec.Builder protectMethod(String methodName, Class returnKlass) {
        return FilerKit.protectMethod(methodName, (TypeName)ClassName.get((Class)returnKlass));
    }

    public static MethodSpec.Builder protectMethod(String methodName, TypeName returnKlass) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName);
        builder.addAnnotation(Override.class);
        if (returnKlass != null) {
            builder.returns(returnKlass);
        }
        builder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        return builder;
    }

    public static AnnotationSpec suppressWarnings(String ... values) {
        String format = Stream.of(values).map(s -> "$S").collect(Collectors.joining(", ", "{", "}"));
        return AnnotationSpec.builder(SuppressWarnings.class).addMember("value", format, (Object[])values).build();
    }
}

