/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.mybatis.filer;

import cn.org.atool.fluent.processor.mybatis.entity.FluentEntity;
import cn.org.atool.fluent.processor.mybatis.filer.ClassNames2;
import cn.org.atool.fluent.processor.mybatis.filer.FilerKit;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public abstract class AbstractFiler {
    protected FluentEntity fluent;
    protected String packageName;
    protected String klassName;
    protected String comment;

    public AbstractFiler(FluentEntity fluent) {
        this.fluent = fluent;
    }

    public final JavaFile javaFile() {
        TypeSpec.Builder builder = this.isInterface() ? TypeSpec.interfaceBuilder((String)this.klassName).addModifiers(new Modifier[]{Modifier.PUBLIC}) : TypeSpec.classBuilder((String)this.klassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.build(builder);
        CodeBlock comment = this.codeBlock("", this.klassName + (this.comment == null ? "" : ": " + this.comment), "", "@author powered by FluentMybatis");
        builder.addJavadoc(comment);
        JavaFile.Builder javaBuilder = JavaFile.builder((String)this.packageName, (TypeSpec)builder.build());
        this.staticImport(javaBuilder);
        javaBuilder.skipJavaLangImports(true);
        return javaBuilder.build();
    }

    protected void staticImport(JavaFile.Builder spec) {
    }

    protected CodeBlock codeBlock(String ... lines) {
        return CodeBlock.join((Iterable)Stream.of(lines).map(x$0 -> CodeBlock.of((String)x$0, (Object[])new Object[0])).collect(Collectors.toList()), (String)"\n");
    }

    protected abstract void build(TypeSpec.Builder var1);

    protected TypeName paraType(ClassName raw, Object ... paras) {
        TypeName[] types = this.typeNames(paras);
        return ParameterizedTypeName.get((ClassName)raw, (TypeName[])types);
    }

    protected TypeName paraType(Class raw, Object ... paras) {
        TypeName[] types = this.typeNames(paras);
        return ParameterizedTypeName.get((ClassName)ClassName.get((Class)raw), (TypeName[])types);
    }

    protected TypeName paraType(String typeName, Object ... paras) {
        TypeName[] types = this.typeNames(paras);
        return ParameterizedTypeName.get((ClassName)ClassNames2.getClassName(typeName), (TypeName[])types);
    }

    private TypeName[] typeNames(Object ... paras) {
        ArrayList<Object> types = new ArrayList<Object>(paras.length);
        for (Object p : paras) {
            if (p instanceof String) {
                types.add(TypeVariableName.get((String)((String)p)));
                continue;
            }
            if (p instanceof Class) {
                types.add(ClassName.get((Class)((Class)p)));
                continue;
            }
            types.add((TypeName)p);
        }
        return types.toArray(new TypeName[0]);
    }

    protected abstract boolean isInterface();

    protected MethodSpec m_mapping() {
        return FilerKit.publicMethod("mapping", (TypeName)ClassNames2.CN_Optional_IMapping).addStatement("return Optional.of($L)", new Object[]{"MAPPING"}).build();
    }
}

