/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.mybatis.entity;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.annotation.FluentMybatis;
import cn.org.atool.fluent.mybatis.annotation.GmtCreate;
import cn.org.atool.fluent.mybatis.annotation.GmtModified;
import cn.org.atool.fluent.mybatis.annotation.LogicDelete;
import cn.org.atool.fluent.mybatis.annotation.NotField;
import cn.org.atool.fluent.mybatis.annotation.RefMethod;
import cn.org.atool.fluent.mybatis.annotation.TableField;
import cn.org.atool.fluent.mybatis.annotation.TableId;
import cn.org.atool.fluent.mybatis.annotation.Version;
import cn.org.atool.fluent.mybatis.base.crud.IDefaultSetter;
import cn.org.atool.fluent.mybatis.base.mapper.IMapper;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.processor.mybatis.base.FluentClassName;
import cn.org.atool.fluent.processor.mybatis.entity.CommonField;
import cn.org.atool.fluent.processor.mybatis.entity.EntityRefMethod;
import cn.org.atool.fluent.processor.mybatis.entity.PrimaryField;
import cn.org.atool.fluent.processor.mybatis.filer.ClassNames2;
import cn.org.atool.fluent.processor.mybatis.scanner.ClassAttrParser;
import cn.org.atool.generator.database.model.FieldType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class FluentEntity
extends FluentClassName
implements Comparable<FluentEntity> {
    private String basePack;
    private String entityPack;
    private String className;
    private boolean usedCached;
    private String noSuffix;
    private String tableName;
    private String schema = "";
    private String defaults;
    private String superMapper;
    private String prefix;
    private String suffix;
    private String mapperBeanPrefix;
    private PrimaryField primary;
    private final List<CommonField> fields = new ArrayList<CommonField>();
    private String logicDelete;
    private boolean longTypeOfLogicDelete = false;
    private String versionField;
    private final List<EntityRefMethod> refMethods = new ArrayList<EntityRefMethod>();
    private DbType dbType = DbType.MYSQL;
    private boolean useDao = true;

    public FluentEntity setClassName(String entityPack, String className) {
        this.className = className;
        this.entityPack = entityPack;
        this.basePack = this.getParentPackage(entityPack);
        return this;
    }

    private String getParentPackage(String entityPack) {
        int index = entityPack.lastIndexOf(46);
        return index > 0 ? entityPack.substring(0, index) : entityPack;
    }

    public FluentEntity setFluentMyBatis(FluentMybatis fluentMyBatis, String defaults, String superMapper) {
        this.prefix = fluentMyBatis.prefix();
        this.suffix = fluentMyBatis.suffix();
        this.noSuffix = this.className.replace(this.suffix, "");
        this.defaults = If.isBlank((CharSequence)defaults) ? IDefaultSetter.class.getName() : defaults;
        this.superMapper = If.isBlank((CharSequence)superMapper) ? IMapper.class.getName() : superMapper;
        this.tableName = fluentMyBatis.table();
        if (If.isBlank((CharSequence)this.tableName)) {
            this.tableName = MybatisUtil.tableName((String)this.className, (String)fluentMyBatis.prefix(), (String)fluentMyBatis.suffix());
        }
        this.schema = fluentMyBatis.schema();
        this.mapperBeanPrefix = fluentMyBatis.mapperBeanPrefix();
        this.dbType = fluentMyBatis.dbType();
        this.usedCached = fluentMyBatis.useCached();
        this.useDao = fluentMyBatis.useDao();
        return this;
    }

    public void parseEntity(TypeElement entity, Consumer<String> log) {
        FluentMybatis fluentMybatis = entity.getAnnotation(FluentMybatis.class);
        if (fluentMybatis == null) {
            log.accept("Error in: " + entity.getQualifiedName().toString());
        } else {
            ClassName className = ClassNames2.getClassName(entity.getQualifiedName().toString());
            this.setClassName(className.packageName(), className.simpleName());
            String defaults = ClassAttrParser.getClassAttr(entity, FluentMybatis.class, "defaults()", IDefaultSetter.class);
            String superMapper = ClassAttrParser.getClassAttr(entity, FluentMybatis.class, "superMapper()", IMapper.class);
            this.setFluentMyBatis(fluentMybatis, defaults, superMapper);
        }
    }

    public FluentEntity addMethod(EntityRefMethod method) {
        this.refMethods.add(method);
        return this;
    }

    public void addField(CommonField field) {
        if (this.fields.contains(field)) {
            return;
        }
        if (field.isPrimary() && this.primary == null) {
            this.primary = (PrimaryField)field;
        }
        this.fields.add(field);
    }

    public FluentEntity sort() {
        this.fields.sort(Comparator.naturalOrder());
        return this;
    }

    @Override
    public int compareTo(FluentEntity fluentEntity) {
        return this.className.compareTo(fluentEntity.getClassName());
    }

    public void addMethod(ExecutableElement element) {
        RefMethod ref = element.getAnnotation(RefMethod.class);
        if (ref == null || !this.isPublicMethod(element)) {
            return;
        }
        String methodName = element.getSimpleName().toString();
        EntityRefMethod method = new EntityRefMethod(methodName, ClassName.get((TypeMirror)element.getReturnType()));
        method.setValue(ref.value());
        this.addMethod(method);
    }

    public void visitVariable(VariableElement element) {
        if (this.isTableField(element)) {
            return;
        }
        TableId tableId = element.getAnnotation(TableId.class);
        String fieldName = element.getSimpleName().toString();
        if (tableId == null) {
            CommonField field = this.parseCommonField(fieldName, element);
            this.addField(field);
            this.setFieldType(field, element);
        } else {
            PrimaryField field;
            field.setType((field = this.parsePrimaryField(fieldName, element, tableId)).isAutoIncrease() ? FieldType.PrimaryId : FieldType.PrimaryKey);
            this.addField(field);
        }
    }

    private boolean isTableField(VariableElement element) {
        return element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.TRANSIENT) || element.getAnnotation(NotField.class) != null;
    }

    private boolean isPublicMethod(ExecutableElement element) {
        Set<Modifier> set = element.getModifiers();
        return set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.STATIC) && !set.contains((Object)Modifier.ABSTRACT);
    }

    private void setFieldType(CommonField field, VariableElement element) {
        if (element.getAnnotation(LogicDelete.class) != null) {
            this.setLogicDelete(field.getName());
            this.setLongTypeOfLogicDelete(Objects.equals(field.getJavaType(), ClassNames2.CN_Long));
            field.setType(FieldType.IsDeleted);
        }
        if (element.getAnnotation(Version.class) != null) {
            this.setVersionField(field.getName());
            field.setType(FieldType.Version);
        }
        if (element.getAnnotation(GmtCreate.class) != null) {
            field.setType(FieldType.GmtCreate);
        }
        if (element.getAnnotation(GmtModified.class) != null) {
            field.setType(FieldType.GmtModified);
        }
    }

    private CommonField parseCommonField(String fieldName, VariableElement var) {
        CommonField field = new CommonField(fieldName, ClassNames2.javaType(var));
        TableField tableField = var.getAnnotation(TableField.class);
        if (tableField == null) {
            return field;
        }
        field.setColumn(tableField.value());
        field.setInsert(tableField.insert());
        field.setUpdate(tableField.update());
        field.setNotLarge(tableField.notLarge());
        field.setNumericScale(tableField.numericScale());
        field.setJdbcType(tableField.jdbcType().name());
        field.setTypeHandler(this.getTypeHandler(var, TableField.class.getSimpleName()));
        return field;
    }

    private PrimaryField parsePrimaryField(String fieldName, VariableElement var, TableId tableId) {
        PrimaryField field = new PrimaryField(fieldName, ClassNames2.javaType(var));
        field.setColumn(tableId.value());
        field.setAutoIncrease(tableId.auto());
        field.setSeqIsBeforeOrder(tableId.before());
        field.setJdbcType(tableId.jdbcType().name());
        field.setTypeHandler(this.getTypeHandler(var, TableId.class.getSimpleName()));
        field.setSeqName(tableId.seqName());
        return field;
    }

    private TypeName getTypeHandler(VariableElement var, String aName) {
        for (AnnotationMirror annotationMirror : var.getAnnotationMirrors()) {
            String aTypeName = annotationMirror.getAnnotationType().toString();
            if (!aTypeName.contains(aName)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                String method = entry.getKey().getSimpleName().toString();
                AnnotationValue value = entry.getValue();
                if (!"typeHandler".equals(method)) continue;
                return ClassNames2.getClassName(value.getValue().toString());
            }
        }
        return null;
    }

    @Override
    public String getBasePack() {
        return this.basePack;
    }

    @Override
    public String getEntityPack() {
        return this.entityPack;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public boolean isUsedCached() {
        return this.usedCached;
    }

    @Override
    public String getNoSuffix() {
        return this.noSuffix;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public String getSuperMapper() {
        return this.superMapper;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getMapperBeanPrefix() {
        return this.mapperBeanPrefix;
    }

    public PrimaryField getPrimary() {
        return this.primary;
    }

    @Override
    public List<CommonField> getFields() {
        return this.fields;
    }

    public String getLogicDelete() {
        return this.logicDelete;
    }

    public boolean isLongTypeOfLogicDelete() {
        return this.longTypeOfLogicDelete;
    }

    public String getVersionField() {
        return this.versionField;
    }

    public List<EntityRefMethod> getRefMethods() {
        return this.refMethods;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public boolean isUseDao() {
        return this.useDao;
    }

    public String toString() {
        return "FluentEntity(basePack=" + this.getBasePack() + ", entityPack=" + this.getEntityPack() + ", className=" + this.getClassName() + ", usedCached=" + this.isUsedCached() + ", noSuffix=" + this.getNoSuffix() + ", tableName=" + this.getTableName() + ", schema=" + this.getSchema() + ", defaults=" + this.getDefaults() + ", superMapper=" + this.getSuperMapper() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", mapperBeanPrefix=" + this.getMapperBeanPrefix() + ", primary=" + this.getPrimary() + ", fields=" + this.getFields() + ", logicDelete=" + this.getLogicDelete() + ", longTypeOfLogicDelete=" + this.isLongTypeOfLogicDelete() + ", versionField=" + this.getVersionField() + ", refMethods=" + this.getRefMethods() + ", dbType=" + this.getDbType() + ", useDao=" + this.isUseDao() + ")";
    }

    public void setLogicDelete(String logicDelete) {
        this.logicDelete = logicDelete;
    }

    public void setLongTypeOfLogicDelete(boolean longTypeOfLogicDelete) {
        this.longTypeOfLogicDelete = longTypeOfLogicDelete;
    }

    public void setVersionField(String versionField) {
        this.versionField = versionField;
    }
}

