/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.formservice.scanner;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.processor.AScanner;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;

public class FormServiceScanner
extends AScanner {
    private final Queue<TypeElement> interfaces = new LinkedList<TypeElement>();
    private final Set<String> hasParsed = new HashSet<String>();
    private final List<ExecutableElement> abstractMethods = new ArrayList<ExecutableElement>();

    public FormServiceScanner(ProcessingEnvironment env) {
        super(env.getMessager());
    }

    @Override
    public FormServiceScanner scan(TypeElement element) {
        while (!Objects.equals(element.toString(), Object.class.getName())) {
            this.parseAbstractMethod(element);
            TypeMirror typeMirror = element.getSuperclass();
            if (typeMirror instanceof NoType) break;
            element = this.asTypeElement(typeMirror);
        }
        while (!this.interfaces.isEmpty()) {
            TypeElement type = this.interfaces.poll();
            this.parseAbstractMethod(type);
        }
        return this;
    }

    private void parseAbstractMethod(TypeElement element) {
        for (Element element2 : element.getEnclosedElements()) {
            if (!(element2 instanceof ExecutableElement)) continue;
            ExecutableElement executable = (ExecutableElement)element2;
            Set<Modifier> modifiers = executable.getModifiers();
            String signature = this.signature(executable);
            if (!this.hasParsed.contains(signature) && modifiers.contains((Object)Modifier.ABSTRACT)) {
                this.abstractMethods.add(executable);
            }
            this.hasParsed.add(signature);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            this.interfaces.offer(this.asTypeElement(typeMirror));
        }
    }

    private String signature(ExecutableElement element) {
        ArrayList<String> paras = new ArrayList<String>();
        for (VariableElement variableElement : element.getParameters()) {
            paras.add(this.className(variableElement.asType()));
        }
        return element.getSimpleName() + "(" + String.join((CharSequence)";", paras) + ")";
    }

    private String className(TypeMirror type) {
        TypeName typeName = ClassName.get((TypeMirror)type);
        return FormServiceScanner.className(typeName);
    }

    public static String className(TypeName type) {
        if (type instanceof ClassName) {
            String pack = ((ClassName)type).packageName();
            return pack + (If.isBlank((CharSequence)pack) ? "" : ".") + ((ClassName)type).simpleName();
        }
        if (type instanceof ParameterizedTypeName) {
            ParameterizedTypeName pType = (ParameterizedTypeName)type;
            return FormServiceScanner.className((TypeName)pType.rawType);
        }
        return type.toString();
    }

    public List<ExecutableElement> getAbstractMethods() {
        return this.abstractMethods;
    }
}

