/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.processor.form.scanner;

import cn.org.atool.fluent.form.annotation.Entry;
import cn.org.atool.fluent.form.annotation.EntryType;
import cn.org.atool.fluent.form.annotation.Form;
import cn.org.atool.fluent.processor.form.model.FormField;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner8;
import javax.tools.Diagnostic;

public class FormScanner
extends ElementScanner8<Void, Void> {
    private ClassName className;
    private final List<FormField> metas = new ArrayList<FormField>();
    private final Supplier<Messager> messager;

    public FormScanner(Supplier<Messager> messager) {
        this.messager = messager;
    }

    @Override
    public Void visitType(TypeElement entity, Void aVoid) {
        Form form = entity.getAnnotation(Form.class);
        if (form == null) {
            this.messager.get().printMessage(Diagnostic.Kind.ERROR, "Error in: " + entity.getQualifiedName().toString());
        } else {
            String fullName = entity.getQualifiedName().toString();
            String simpleName = entity.getSimpleName().toString();
            String packName = fullName.substring(0, fullName.length() - simpleName.length() - 1);
            this.className = ClassName.get((String)packName, (String)simpleName, (String[])new String[0]);
        }
        return (Void)super.visitType(entity, aVoid);
    }

    @Override
    public Void visitVariable(VariableElement element, Void aVoid) {
        String entryName;
        if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.TRANSIENT)) {
            return (Void)super.visitVariable(element, aVoid);
        }
        Entry entry = element.getAnnotation(Entry.class);
        String fieldName = element.getSimpleName().toString();
        String string = entryName = entry == null ? "" : entry.value().trim();
        if (entryName.isEmpty()) {
            entryName = fieldName;
        }
        TypeName fieldType = this.getJavaType(element);
        FormField meta = new FormField(entryName, fieldName, fieldType);
        if (entry == null) {
            meta.setEntryType(EntryType.EQ, true);
        } else {
            meta.setEntryType(entry.type(), entry.ignoreNull());
        }
        this.metas.add(meta);
        return (Void)super.visitVariable(element, aVoid);
    }

    private TypeName getJavaType(VariableElement var) {
        TypeName type = ClassName.get((TypeMirror)var.asType());
        return type instanceof ParameterizedTypeName ? ((ParameterizedTypeName)type).rawType : type;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public List<FormField> getMetas() {
        return this.metas;
    }
}

