/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.trade.view;

import com.almasb.fxgl.trade.Shop;
import com.almasb.fxgl.trade.TradeItem;
import com.almasb.fxgl.trade.view.TradeListView;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/almasb/fxgl/trade/view/ShopView;", "T", "Ljavafx/scene/layout/Pane;", "shop", "Lcom/almasb/fxgl/trade/Shop;", "width", "", "height", "(Lcom/almasb/fxgl/trade/Shop;II)V", "box", "Ljavafx/scene/layout/VBox;", "listView", "Lcom/almasb/fxgl/trade/view/TradeListView;", "getListView", "()Lcom/almasb/fxgl/trade/view/TradeListView;", "getShop", "()Lcom/almasb/fxgl/trade/Shop;", "fxgl-gameplay"})
public final class ShopView<T>
extends Pane {
    @NotNull
    private final Shop<T> shop;
    @NotNull
    private final VBox box;
    @NotNull
    private final TradeListView listView;

    public ShopView(@NotNull Shop<T> shop, int width, int height) {
        Intrinsics.checkNotNullParameter(shop, (String)"shop");
        this.shop = shop;
        this.setPrefSize(width, height);
        Rectangle bg = new Rectangle((double)width, (double)height);
        bg.setFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.6));
        Rectangle lineTop = new Rectangle((double)width, 4.0);
        lineTop.setFill((Paint)Color.rgb((int)25, (int)250, (int)25));
        lineTop.setStroke((Paint)Color.BLACK);
        lineTop.setStrokeWidth(1.3);
        Rectangle lineBot = new Rectangle((double)width, 4.0);
        lineBot.setTranslateY((double)(height - 40 - 2));
        lineBot.setFill((Paint)Color.rgb((int)25, (int)250, (int)25));
        lineBot.setStroke((Paint)Color.BLACK);
        lineBot.setStrokeWidth(1.3);
        this.box = new VBox(5.0);
        this.box.setTranslateX(25.0);
        this.box.setTranslateY(25.0);
        Text textMoney = new Text();
        textMoney.setFill((Paint)Color.YELLOW);
        textMoney.setFont(Font.font((double)22.0));
        textMoney.textProperty().bind((ObservableValue)this.shop.moneyProperty().asString("Money: %d"));
        textMoney.setTranslateX(25.0);
        textMoney.setTranslateY((double)height - (double)10);
        ObservableList<TradeItem<T>> observableList = this.shop.getItems();
        Intrinsics.checkNotNull(observableList, (String)"null cannot be cast to non-null type javafx.collections.ObservableList<com.almasb.fxgl.trade.TradeItem<*>>");
        this.listView = new TradeListView(observableList);
        this.listView.setTranslateX(10.0);
        this.listView.setTranslateY(25.0);
        this.listView.setPrefSize(width - 20, height - 50 - 40);
        Object[] objectArray = new Node[]{(Node)bg, (Node)lineTop, (Node)lineBot, (Node)this.box, (Node)this.listView, (Node)textMoney};
        this.getChildren().addAll(objectArray);
    }

    @NotNull
    public final Shop<T> getShop() {
        return this.shop;
    }

    @NotNull
    public final TradeListView getListView() {
        return this.listView;
    }
}

