/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.inventory;

import com.almasb.fxgl.inventory.ItemStack;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000fH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0010\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\u000fH\u0002J\u0015\u00102\u001a\u00020/2\u0006\u00100\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b3J\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u001a\u001a\u00020\u001bJ\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0-R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u000bR\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RM\u0010\u001c\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u001f*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001e0\u001e \u001f*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u001f*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001e0\u001e\u0018\u00010\u001d0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\u0003\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u0004R$\u0010'\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020&8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020&0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/almasb/fxgl/inventory/ItemData;", "T", "", "userItem", "(Ljava/lang/Object;)V", "value", "", "description", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "descriptionProperty", "Ljavafx/beans/property/SimpleStringProperty;", "maxStackQuantity", "", "getMaxStackQuantity", "()I", "setMaxStackQuantity", "(I)V", "name", "getName", "setName", "nameProperty", "quantity", "getQuantity", "quantityProperty", "Ljavafx/beans/property/SimpleIntegerProperty;", "stacks", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/inventory/ItemStack;", "kotlin.jvm.PlatformType", "getStacks", "()Ljavafx/collections/ObservableList;", "getUserItem", "()Ljava/lang/Object;", "setUserItem", "Ljava/lang/Object;", "Ljavafx/scene/Node;", "view", "getView", "()Ljavafx/scene/Node;", "setView", "(Ljavafx/scene/Node;)V", "viewProperty", "Ljavafx/beans/property/SimpleObjectProperty;", "deplete", "", "amount", "fill", "incrementQuantity", "incrementQuantity$fxgl_gameplay", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nInventory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Inventory.kt\ncom/almasb/fxgl/inventory/ItemData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,380:1\n1#2:381\n*E\n"})
public final class ItemData<T> {
    private T userItem;
    @NotNull
    private final SimpleObjectProperty<Node> viewProperty;
    @NotNull
    private final SimpleStringProperty nameProperty;
    @NotNull
    private final SimpleStringProperty descriptionProperty;
    @NotNull
    private final SimpleIntegerProperty quantityProperty;
    private final ObservableList<ItemStack<T>> stacks;
    private int maxStackQuantity;

    public ItemData(T userItem) {
        this.userItem = userItem;
        this.viewProperty = new SimpleObjectProperty();
        this.nameProperty = new SimpleStringProperty();
        this.descriptionProperty = new SimpleStringProperty();
        this.quantityProperty = new SimpleIntegerProperty();
        this.stacks = FXCollections.observableArrayList();
        this.maxStackQuantity = Integer.MAX_VALUE;
    }

    public final T getUserItem() {
        return this.userItem;
    }

    public final void setUserItem(T t) {
        this.userItem = t;
    }

    public final ObservableList<ItemStack<T>> getStacks() {
        return this.stacks;
    }

    public final int getMaxStackQuantity() {
        return this.maxStackQuantity;
    }

    public final void setMaxStackQuantity(int n) {
        this.maxStackQuantity = n;
    }

    @NotNull
    public final SimpleObjectProperty<Node> viewProperty() {
        return this.viewProperty;
    }

    @NotNull
    public final SimpleStringProperty nameProperty() {
        return this.nameProperty;
    }

    @NotNull
    public final SimpleStringProperty descriptionProperty() {
        return this.descriptionProperty;
    }

    @NotNull
    public final SimpleIntegerProperty quantityProperty() {
        return this.quantityProperty;
    }

    @NotNull
    public final Node getView() {
        Object object = this.viewProperty.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"viewProperty.value");
        return (Node)object;
    }

    public final void setView(@NotNull Node value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.viewProperty.setValue((Object)value);
    }

    @NotNull
    public final String getName() {
        String string = this.nameProperty.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameProperty.value");
        return string;
    }

    public final void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.nameProperty.setValue(value);
    }

    @NotNull
    public final String getDescription() {
        String string = this.descriptionProperty.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptionProperty.value");
        return string;
    }

    public final void setDescription(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.descriptionProperty.setValue(value);
    }

    public final int getQuantity() {
        Integer n = this.quantityProperty.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"quantityProperty.value");
        return ((Number)n).intValue();
    }

    public final void incrementQuantity$fxgl_gameplay(int amount) {
        if (amount > 0) {
            this.fill(amount);
        } else if (amount < 0) {
            this.deplete(-amount);
        }
    }

    private final void fill(int amount) {
        int left = amount;
        for (ItemStack stack : this.stacks) {
            SimpleIntegerProperty simpleIntegerProperty;
            if (stack.getQuantity() >= this.maxStackQuantity) continue;
            int availableSpace = this.maxStackQuantity - stack.getQuantity();
            if (left <= availableSpace) {
                stack.setQuantity(stack.getQuantity() + left);
                simpleIntegerProperty = this.quantityProperty;
                simpleIntegerProperty.setValue((Number)(simpleIntegerProperty.getValue() + left));
                left = 0;
                break;
            }
            stack.setQuantity(this.maxStackQuantity);
            simpleIntegerProperty = this.quantityProperty;
            simpleIntegerProperty.setValue((Number)(simpleIntegerProperty.getValue() + availableSpace));
            left -= availableSpace;
        }
        if (left > 0) {
            int numFullStacks = left / this.maxStackQuantity;
            int remainder = left % this.maxStackQuantity;
            int n = 0;
            while (n < numFullStacks) {
                ItemStack<T> itemStack;
                int it = n++;
                boolean bl = false;
                ObservableList<ItemStack<T>> observableList = this.stacks;
                Intrinsics.checkNotNullExpressionValue(observableList, (String)"stacks");
                Collection collection = (Collection)observableList;
                ItemStack<T> it2 = itemStack = new ItemStack<T>(this.userItem);
                boolean bl2 = false;
                it2.setQuantity(this.maxStackQuantity);
                collection.add(itemStack);
                collection = this.quantityProperty;
                collection.setValue(collection.getValue() + this.maxStackQuantity);
            }
            if (remainder > 0) {
                ItemStack<T> itemStack;
                ObservableList<ItemStack<T>> observableList = this.stacks;
                Intrinsics.checkNotNullExpressionValue(observableList, (String)"stacks");
                Collection collection = (Collection)observableList;
                ItemStack<T> it = itemStack = new ItemStack<T>(this.userItem);
                boolean bl = false;
                it.setQuantity(remainder);
                collection.add(itemStack);
                collection = this.quantityProperty;
                collection.setValue(collection.getValue() + remainder);
            }
        }
    }

    private final void deplete(int amount) {
        int left = amount;
        while (left > 0) {
            SimpleIntegerProperty simpleIntegerProperty;
            ObservableList<ItemStack<T>> observableList = this.stacks;
            Intrinsics.checkNotNullExpressionValue(observableList, (String)"stacks");
            ItemStack lastStack = (ItemStack)CollectionsKt.last((List)((List)observableList));
            if (left >= lastStack.getQuantity()) {
                simpleIntegerProperty = this.quantityProperty;
                simpleIntegerProperty.setValue((Number)(simpleIntegerProperty.getValue() - lastStack.getQuantity()));
                left -= lastStack.getQuantity();
                lastStack.setQuantity(0);
                ObservableList<ItemStack<T>> observableList2 = this.stacks;
                Intrinsics.checkNotNullExpressionValue(observableList2, (String)"stacks");
                CollectionsKt.removeLast((List)((List)observableList2));
                continue;
            }
            simpleIntegerProperty = this.quantityProperty;
            simpleIntegerProperty.setValue((Number)(simpleIntegerProperty.getValue() - left));
            lastStack.setQuantity(lastStack.getQuantity() - left);
            left = 0;
        }
    }
}

