/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.cutscene.dialogue;

import com.almasb.fxgl.cutscene.dialogue.DialogueChoiceEdge;
import com.almasb.fxgl.cutscene.dialogue.DialogueEdge;
import com.almasb.fxgl.cutscene.dialogue.DialogueNode;
import com.almasb.fxgl.cutscene.dialogue.DialogueNodeType;
import com.almasb.fxgl.cutscene.dialogue.StartNode;
import com.almasb.fxgl.cutscene.dialogue.TextNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\rJ\u001e\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\rJ\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0003J\u0010\u0010(\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020\rJ\u0018\u0010(\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0003J\u001e\u0010)\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010*\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010+\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\rR5\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nRQ\u0010\u000b\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0004\u00a8\u0006,"}, d2={"Lcom/almasb/fxgl/cutscene/dialogue/DialogueGraph;", "", "uniqueID", "", "(I)V", "edges", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/cutscene/dialogue/DialogueEdge;", "kotlin.jvm.PlatformType", "getEdges", "()Ljavafx/collections/ObservableList;", "nodes", "Ljavafx/collections/ObservableMap;", "Lcom/almasb/fxgl/cutscene/dialogue/DialogueNode;", "getNodes", "()Ljavafx/collections/ObservableMap;", "startNode", "Lcom/almasb/fxgl/cutscene/dialogue/StartNode;", "getStartNode", "()Lcom/almasb/fxgl/cutscene/dialogue/StartNode;", "getUniqueID$fxgl_gameplay", "()I", "setUniqueID$fxgl_gameplay", "addChoiceEdge", "", "source", "optionID", "target", "addEdge", "edge", "addNode", "node", "appendGraph", "graph", "containsNode", "", "copy", "findNodeID", "getNodeByID", "id", "nextNode", "removeChoiceEdge", "removeEdge", "removeNode", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nDialogueGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogueGraph.kt\ncom/almasb/fxgl/cutscene/dialogue/DialogueGraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1#2:272\n766#3:273\n857#3,2:274\n1549#3:276\n1620#3,3:277\n1855#3,2:280\n1855#3,2:282\n766#3:284\n857#3,2:285\n1855#3,2:287\n1855#3,2:289\n1855#3:291\n766#3:292\n857#3,2:293\n1855#3,2:295\n1856#3:297\n*S KotlinDebug\n*F\n+ 1 DialogueGraph.kt\ncom/almasb/fxgl/cutscene/dialogue/DialogueGraph\n*L\n213#1:273\n213#1:274,2\n218#1:276\n218#1:277,3\n221#1:280,2\n227#1:282,2\n231#1:284\n231#1:285,2\n232#1:287,2\n244#1:289,2\n247#1:291\n249#1:292\n249#1:293,2\n250#1:295,2\n247#1:297\n*E\n"})
public final class DialogueGraph {
    private int uniqueID;
    private final ObservableMap<Integer, DialogueNode> nodes;
    private final ObservableList<DialogueEdge> edges;

    public DialogueGraph(int uniqueID) {
        this.uniqueID = uniqueID;
        this.nodes = FXCollections.observableMap((Map)new HashMap());
        this.edges = FXCollections.observableArrayList();
    }

    public /* synthetic */ DialogueGraph(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public final int getUniqueID$fxgl_gameplay() {
        return this.uniqueID;
    }

    public final void setUniqueID$fxgl_gameplay(int n) {
        this.uniqueID = n;
    }

    public final ObservableMap<Integer, DialogueNode> getNodes() {
        return this.nodes;
    }

    public final ObservableList<DialogueEdge> getEdges() {
        return this.edges;
    }

    @NotNull
    public final StartNode getStartNode() {
        Object v0;
        block2: {
            Iterable iterable = this.nodes.values();
            for (Object t : iterable) {
                DialogueNode it = (DialogueNode)t;
                boolean bl = false;
                if (!(it.getType() == DialogueNodeType.START)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Object var1_6 = v0;
        StartNode startNode = var1_6 instanceof StartNode ? (StartNode)var1_6 : null;
        if (startNode == null) {
            throw new IllegalStateException("No start node in this graph.");
        }
        return startNode;
    }

    public final void addNode(@NotNull DialogueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ObservableMap<Integer, DialogueNode> observableMap = this.nodes;
        Intrinsics.checkNotNullExpressionValue(observableMap, (String)"nodes");
        Map map = (Map)observableMap;
        int n = this.uniqueID;
        this.uniqueID = n + 1;
        map.put(n, node);
    }

    public final void removeNode(@NotNull DialogueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int id = this.findNodeID(node);
        this.nodes.remove((Object)id);
        this.edges.removeIf(arg_0 -> DialogueGraph.removeNode$lambda$1((Function1)new Function1<DialogueEdge, Boolean>(node){
            final /* synthetic */ DialogueNode $node;
            {
                this.$node = $node;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DialogueEdge it) {
                return it.getSource() == this.$node || it.getTarget() == this.$node;
            }
        }, arg_0));
    }

    public final void addEdge(@NotNull DialogueEdge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        ObservableList<DialogueEdge> observableList = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
        ((Collection)observableList).add(edge);
    }

    public final void removeEdge(@NotNull DialogueEdge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        ObservableList<DialogueEdge> observableList = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
        ((Collection)observableList).remove(edge);
    }

    public final void addEdge(@NotNull DialogueNode source, @NotNull DialogueNode target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ObservableList<DialogueEdge> observableList = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
        Collection collection = (Collection)observableList;
        collection.add(new DialogueEdge(source, target));
    }

    public final void addChoiceEdge(@NotNull DialogueNode source, int optionID, @NotNull DialogueNode target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ObservableList<DialogueEdge> observableList = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
        Collection collection = (Collection)observableList;
        collection.add(new DialogueChoiceEdge(source, optionID, target));
    }

    public final void removeEdge(@NotNull DialogueNode source, @NotNull DialogueNode target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.edges.removeIf(arg_0 -> DialogueGraph.removeEdge$lambda$2((Function1)new Function1<DialogueEdge, Boolean>(source, target){
            final /* synthetic */ DialogueNode $source;
            final /* synthetic */ DialogueNode $target;
            {
                this.$source = $source;
                this.$target = $target;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DialogueEdge it) {
                return it.getSource() == this.$source && it.getTarget() == this.$target;
            }
        }, arg_0));
    }

    public final void removeChoiceEdge(@NotNull DialogueNode source, int optionID, @NotNull DialogueNode target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.edges.removeIf(arg_0 -> DialogueGraph.removeChoiceEdge$lambda$3((Function1)new Function1<DialogueEdge, Boolean>(source, optionID, target){
            final /* synthetic */ DialogueNode $source;
            final /* synthetic */ int $optionID;
            final /* synthetic */ DialogueNode $target;
            {
                this.$source = $source;
                this.$optionID = $optionID;
                this.$target = $target;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DialogueEdge it) {
                return it instanceof DialogueChoiceEdge && it.getSource() == this.$source && ((DialogueChoiceEdge)it).getOptionID() == this.$optionID && it.getTarget() == this.$target;
            }
        }, arg_0));
    }

    public final boolean containsNode(@NotNull DialogueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.nodes.values().contains(node);
    }

    public final int findNodeID(@NotNull DialogueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ObservableMap<Integer, DialogueNode> observableMap = this.nodes;
        Intrinsics.checkNotNullExpressionValue(observableMap, (String)"nodes");
        for (Map.Entry entry : ((Map)observableMap).entrySet()) {
            Integer id = (Integer)entry.getKey();
            DialogueNode n = (DialogueNode)entry.getValue();
            if (n != node) continue;
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            return id;
        }
        return -1;
    }

    @NotNull
    public final DialogueNode getNodeByID(int id) {
        DialogueNode dialogueNode = (DialogueNode)this.nodes.get((Object)id);
        if (dialogueNode == null) {
            throw new IllegalArgumentException("Graph does not contain a node with id " + id);
        }
        return dialogueNode;
    }

    @Nullable
    public final DialogueNode nextNode(@NotNull DialogueNode node) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ObservableList<DialogueEdge> observableList = this.edges;
            Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
            Iterable iterable = (Iterable)observableList;
            for (Object t : iterable) {
                DialogueEdge it = (DialogueEdge)t;
                boolean bl = false;
                if (!(it.getSource() == node)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        DialogueEdge dialogueEdge = v1;
        return dialogueEdge != null ? dialogueEdge.getTarget() : null;
    }

    @Nullable
    public final DialogueNode nextNode(@NotNull DialogueNode node, int optionID) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ObservableList<DialogueEdge> observableList = this.edges;
            Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
            Iterable iterable = (Iterable)observableList;
            for (Object t : iterable) {
                DialogueEdge it = (DialogueEdge)t;
                boolean bl = false;
                if (!(it instanceof DialogueChoiceEdge && it.getSource() == node && ((DialogueChoiceEdge)it).getOptionID() == optionID)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        DialogueEdge dialogueEdge = v1;
        return dialogueEdge != null ? dialogueEdge.getTarget() : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void appendGraph(@NotNull DialogueNode source, @NotNull DialogueNode target, @NotNull DialogueGraph graph) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        DialogueEdge it;
        Iterator $this$mapTo$iv$iv;
        Object it2;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        StartNode start = graph.getStartNode();
        Iterable $this$filter$iv2 = graph.nodes.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (DialogueNode)element$iv$iv;
            boolean bl = false;
            if (!(((DialogueNode)it2).getType() == DialogueNodeType.END)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List endNodes = (List)destination$iv$iv;
        TextNode newStart = new TextNode(start.getText());
        Iterable $this$map$iv = endNodes;
        boolean $i$f$map = false;
        Iterable $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        it2 = $this$mapTo$iv$iv.iterator();
        while (it2.hasNext()) {
            Object item$iv$iv = it2.next();
            DialogueNode dialogueNode = (DialogueNode)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new TextNode(((DialogueNode)((Object)it)).getText()));
        }
        List newEndNodes = (List)destination$iv$iv2;
        this.addNode(newStart);
        Iterable $this$forEach$iv = newEndNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextNode it3 = (TextNode)element$iv;
            boolean bl = false;
            this.addNode(it3);
        }
        $this$forEach$iv = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)graph.nodes.values(), (Object)start), (Iterable)endNodes);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DialogueNode it4 = (DialogueNode)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it4, (String)"it");
            this.addNode(it4);
        }
        ObservableList<DialogueEdge> observableList = graph.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"graph.edges");
        $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$filter2 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DialogueEdge)element$iv$iv;
            boolean bl2 = false;
            if (!(this.containsNode(it.getSource()) && this.containsNode(it.getTarget()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DialogueEdge it5 = (DialogueEdge)element$iv;
            boolean bl = false;
            if (it5 instanceof DialogueChoiceEdge) {
                this.addChoiceEdge(it5.getSource(), ((DialogueChoiceEdge)it5).getOptionID(), it5.getTarget());
                continue;
            }
            this.addEdge(it5.getSource(), it5.getTarget());
        }
        this.addEdge(source, newStart);
        $this$forEach$iv = newEndNodes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextNode it6 = (TextNode)element$iv;
            boolean bl = false;
            this.addEdge(it6, target);
        }
        DialogueNode dialogueNode = newStart;
        DialogueNode dialogueNode2 = graph.nextNode(start);
        Intrinsics.checkNotNull((Object)dialogueNode2);
        this.addEdge(dialogueNode, dialogueNode2);
        $this$forEach$iv = newEndNodes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv3;
            Iterable $this$filter$iv3;
            TextNode endNode = (TextNode)element$iv;
            boolean bl = false;
            ObservableList<DialogueEdge> observableList2 = graph.edges;
            Intrinsics.checkNotNullExpressionValue(observableList2, (String)"graph.edges");
            Iterable element$iv$iv = (Iterable)observableList2;
            boolean $i$f$filter3 = false;
            void bl2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
                DialogueEdge it7 = (DialogueEdge)element$iv$iv2;
                boolean bl3 = false;
                if (!(it7.getTarget().getType() == DialogueNodeType.END)) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            $this$filter$iv3 = (List)destination$iv$iv3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DialogueEdge it8 = (DialogueEdge)element$iv2;
                boolean bl4 = false;
                if (it8 instanceof DialogueChoiceEdge) {
                    this.addChoiceEdge(it8.getSource(), ((DialogueChoiceEdge)it8).getOptionID(), endNode);
                    continue;
                }
                this.addEdge(it8.getSource(), endNode);
            }
        }
    }

    @NotNull
    public final DialogueGraph copy() {
        DialogueGraph copy = new DialogueGraph(this.uniqueID);
        ObservableMap<Integer, DialogueNode> observableMap = copy.nodes;
        ObservableMap<Integer, DialogueNode> observableMap2 = this.nodes;
        Intrinsics.checkNotNullExpressionValue(observableMap2, (String)"nodes");
        observableMap.putAll((Map)observableMap2);
        ObservableList<DialogueEdge> observableList = copy.edges;
        ObservableList<DialogueEdge> observableList2 = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList2, (String)"edges");
        observableList.addAll((Collection)observableList2);
        return copy;
    }

    private static final boolean removeNode$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeEdge$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeChoiceEdge$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public DialogueGraph() {
        this(0, 1, null);
    }
}

