/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.achievement;

import com.almasb.fxgl.achievement.Achievement;
import com.almasb.fxgl.achievement.AchievementEvent;
import com.almasb.fxgl.achievement.AchievementProgressEvent;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.PropertyChangeListener;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.SceneService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.event.Event;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0015\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b!J \u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00052\u0006\u0010#\u001a\u00020&H\u0002J \u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00052\u0006\u0010#\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/almasb/fxgl/achievement/AchievementService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "achievements", "", "Lcom/almasb/fxgl/achievement/Achievement;", "achievementsCopy", "", "getAchievementsCopy", "()Ljava/util/List;", "achievementsFromSettings", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "log", "Lcom/almasb/fxgl/logging/Logger;", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "bindToVars", "", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "bindToVars$fxgl_gameplay", "getAchievementByName", "name", "", "onGameReady", "onInit", "onMainLoopStarting", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "registerAchievement", "a", "registerAchievement$fxgl_gameplay", "registerBooleanAchievement", "value", "", "registerDoubleAchievement", "", "registerIntAchievement", "", "write", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nAchievementService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AchievementService.kt\ncom/almasb/fxgl/achievement/AchievementService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1#2:187\n2624#3,3:188\n1855#3,2:191\n766#3:193\n857#3,2:194\n1855#3,2:196\n1855#3,2:198\n1855#3,2:200\n*S KotlinDebug\n*F\n+ 1 AchievementService.kt\ncom/almasb/fxgl/achievement/AchievementService\n*L\n65#1:188,3\n74#1:191,2\n83#1:193\n83#1:194,2\n83#1:196,2\n176#1:198,2\n180#1:200,2\n*E\n"})
public final class AchievementService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    @Inject(value="achievements")
    private List<Achievement> achievementsFromSettings;
    private SceneService sceneService;
    private EventBus eventBus;
    @NotNull
    private final List<Achievement> achievements = new ArrayList();

    @NotNull
    public final List<Achievement> getAchievementsCopy() {
        List<Achievement> list = Collections.unmodifiableList(this.achievements);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(achievements)");
        return list;
    }

    public void onInit() {
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
            sceneService = null;
        }
        this.eventBus = sceneService.getEventBus();
    }

    @NotNull
    public final Achievement getAchievementByName(@NotNull String name) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.achievements;
            for (Object t : iterable) {
                Achievement it = (Achievement)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Achievement achievement = v0;
        if (achievement == null) {
            throw new IllegalArgumentException("Achievement with name [" + name + "] is not registered!");
        }
        return achievement;
    }

    public final void registerAchievement$fxgl_gameplay(@NotNull Achievement a) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Iterable $this$none$iv = this.achievements;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Achievement it = (Achievement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)a.getName())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Achievement with name [" + a.getName() + "] exists";
            throw new IllegalArgumentException(string.toString());
        }
        this.achievements.add(a);
        this.log.debug("Registered new achievement: " + a.getName());
    }

    public void onMainLoopStarting() {
        List<Achievement> list = this.achievementsFromSettings;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"achievementsFromSettings");
            list = null;
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement it = (Achievement)element$iv;
            boolean bl = false;
            this.registerAchievement$fxgl_gameplay(it);
        }
    }

    public void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkNotNullParameter((Object)vars, (String)"vars");
        this.bindToVars$fxgl_gameplay(vars);
    }

    /*
     * WARNING - void declaration
     */
    public final void bindToVars$fxgl_gameplay(@NotNull PropertyMap vars) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vars, (String)"vars");
        Iterable $this$filter$iv = this.achievements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Achievement it = (Achievement)element$iv$iv;
            boolean bl = false;
            if (!(!it.isAchieved())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement it = (Achievement)element$iv;
            boolean bl = false;
            if (!vars.exists(it.getVarName())) {
                this.log.warning("Achievement " + it.getName() + " cannot find property " + it.getVarName());
                continue;
            }
            Object object = it.getVarValue();
            if (object instanceof Integer) {
                this.registerIntAchievement(vars, it, ((Number)it.getVarValue()).intValue());
                continue;
            }
            if (object instanceof Double) {
                this.registerDoubleAchievement(vars, it, ((Number)it.getVarValue()).doubleValue());
                continue;
            }
            if (object instanceof Boolean) {
                this.registerBooleanAchievement(vars, it, (Boolean)it.getVarValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown value type for achievement: " + it.getVarValue());
        }
    }

    private final void registerIntAchievement(PropertyMap vars, Achievement a, int value) {
        Ref.ObjectRef listener = new Ref.ObjectRef();
        listener.element = new PropertyChangeListener<Integer>(value, this, a, vars, (Ref.ObjectRef<PropertyChangeListener<Integer>>)listener){
            private boolean halfReached;
            final /* synthetic */ int $value;
            final /* synthetic */ AchievementService this$0;
            final /* synthetic */ Achievement $a;
            final /* synthetic */ PropertyMap $vars;
            final /* synthetic */ Ref.ObjectRef<PropertyChangeListener<Integer>> $listener;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                this.$a = $a;
                this.$vars = $vars;
                this.$listener = $listener;
            }

            public void onChange(int prev, int now) {
                if (!this.halfReached && now >= this.$value / 2) {
                    this.halfReached = true;
                    EventBus eventBus = AchievementService.access$getEventBus$p(this.this$0);
                    if (eventBus == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"eventBus");
                        eventBus = null;
                    }
                    eventBus.fireEvent((Event)new AchievementProgressEvent(this.$a, now, this.$value));
                }
                if (now >= this.$value) {
                    this.$a.setAchieved$fxgl_gameplay();
                    EventBus eventBus = AchievementService.access$getEventBus$p(this.this$0);
                    if (eventBus == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"eventBus");
                        eventBus = null;
                    }
                    eventBus.fireEvent((Event)new AchievementEvent(AchievementEvent.ACHIEVED, this.$a));
                    String string = this.$a.getVarName();
                    Object object = this.$listener.element;
                    Intrinsics.checkNotNull((Object)object);
                    this.$vars.removeListener(string, (PropertyChangeListener)object);
                }
            }
        };
        vars.addListener(a.getVarName(), (PropertyChangeListener)listener.element);
    }

    private final void registerDoubleAchievement(PropertyMap vars, Achievement a, double value) {
        Ref.ObjectRef listener = new Ref.ObjectRef();
        listener.element = new PropertyChangeListener<Double>(value, this, a, vars, (Ref.ObjectRef<PropertyChangeListener<Double>>)listener){
            private boolean halfReached;
            final /* synthetic */ double $value;
            final /* synthetic */ AchievementService this$0;
            final /* synthetic */ Achievement $a;
            final /* synthetic */ PropertyMap $vars;
            final /* synthetic */ Ref.ObjectRef<PropertyChangeListener<Double>> $listener;
            {
                this.$value = $value;
                this.this$0 = $receiver;
                this.$a = $a;
                this.$vars = $vars;
                this.$listener = $listener;
            }

            public void onChange(double prev, double now) {
                if (!this.halfReached && now >= this.$value / (double)2) {
                    this.halfReached = true;
                    EventBus eventBus = AchievementService.access$getEventBus$p(this.this$0);
                    if (eventBus == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"eventBus");
                        eventBus = null;
                    }
                    eventBus.fireEvent((Event)new AchievementProgressEvent(this.$a, now, this.$value));
                }
                if (now >= this.$value) {
                    this.$a.setAchieved$fxgl_gameplay();
                    EventBus eventBus = AchievementService.access$getEventBus$p(this.this$0);
                    if (eventBus == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"eventBus");
                        eventBus = null;
                    }
                    eventBus.fireEvent((Event)new AchievementEvent(AchievementEvent.ACHIEVED, this.$a));
                    String string = this.$a.getVarName();
                    Object object = this.$listener.element;
                    Intrinsics.checkNotNull((Object)object);
                    this.$vars.removeListener(string, (PropertyChangeListener)object);
                }
            }
        };
        vars.addListener(a.getVarName(), (PropertyChangeListener)listener.element);
    }

    private final void registerBooleanAchievement(PropertyMap vars, Achievement a, boolean value) {
        Ref.ObjectRef listener = new Ref.ObjectRef();
        listener.element = new PropertyChangeListener<Boolean>(value, a, this, vars, (Ref.ObjectRef<PropertyChangeListener<Boolean>>)listener){
            final /* synthetic */ boolean $value;
            final /* synthetic */ Achievement $a;
            final /* synthetic */ AchievementService this$0;
            final /* synthetic */ PropertyMap $vars;
            final /* synthetic */ Ref.ObjectRef<PropertyChangeListener<Boolean>> $listener;
            {
                this.$value = $value;
                this.$a = $a;
                this.this$0 = $receiver;
                this.$vars = $vars;
                this.$listener = $listener;
            }

            public void onChange(boolean prev, boolean now) {
                if (now == this.$value) {
                    this.$a.setAchieved$fxgl_gameplay();
                    EventBus eventBus = AchievementService.access$getEventBus$p(this.this$0);
                    if (eventBus == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"eventBus");
                        eventBus = null;
                    }
                    eventBus.fireEvent((Event)new AchievementEvent(AchievementEvent.ACHIEVED, this.$a));
                    String string = this.$a.getVarName();
                    Object object = this.$listener.element;
                    Intrinsics.checkNotNull((Object)object);
                    this.$vars.removeListener(string, (PropertyChangeListener)object);
                }
            }
        };
        vars.addListener(a.getVarName(), (PropertyChangeListener)listener.element);
    }

    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Iterable $this$forEach$iv = this.achievements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement it = (Achievement)element$iv;
            boolean bl = false;
            bundle.put(it.getName(), (Serializable)Boolean.valueOf(it.isAchieved()));
        }
    }

    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Iterable $this$forEach$iv = this.achievements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement it = (Achievement)element$iv;
            boolean bl = false;
            boolean isAchieved = (Boolean)bundle.get(it.getName());
            if (!isAchieved) continue;
            it.setAchieved$fxgl_gameplay();
        }
    }

    public static final /* synthetic */ EventBus access$getEventBus$p(AchievementService $this) {
        return $this.eventBus;
    }
}

